/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.grounding;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.UnnamedStreamPipesEntity;
import org.streampipes.model.grounding.TopicDefinition;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/TransportProtocol")
@Entity
@MappedSuperclass
public abstract class TransportProtocol
extends UnnamedStreamPipesEntity {
    private static final long serialVersionUID = 7625791395504335184L;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/brokerHostname")
    private String brokerHostname;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/topic")
    private TopicDefinition topicDefinition;

    public TransportProtocol() {
    }

    public TransportProtocol(String uri, TopicDefinition topicDefinition) {
        this.brokerHostname = uri;
        this.topicDefinition = topicDefinition;
    }

    public TransportProtocol(TransportProtocol other) {
        super(other);
        this.brokerHostname = other.getBrokerHostname();
        if (other.getTopicDefinition() != null) {
            this.topicDefinition = new Cloner().topicDefinition(other.getTopicDefinition());
        }
    }

    public String getBrokerHostname() {
        return this.brokerHostname;
    }

    public void setBrokerHostname(String uri) {
        this.brokerHostname = uri;
    }

    public TopicDefinition getTopicDefinition() {
        return this.topicDefinition;
    }

    public void setTopicDefinition(TopicDefinition topicDefinition) {
        this.topicDefinition = topicDefinition;
    }
}

