/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.schema;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.Namespaces;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.UnnamedStreamPipesEntity;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.util.Cloner;

@Namespaces(value={"sp", "https://streampipes.org/vocabulary/v1/"})
@RdfsClass(value="https://streampipes.org/vocabulary/v1/EventSchema")
@Entity
public class EventSchema
extends UnnamedStreamPipesEntity {
    private static final long serialVersionUID = -3994041794693686406L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEventProperty")
    private List<EventProperty> eventProperties;

    public EventSchema(List<EventProperty> eventProperties) {
        this.eventProperties = eventProperties;
    }

    public EventSchema() {
        this.eventProperties = new ArrayList<EventProperty>();
    }

    public EventSchema(EventSchema other) {
        super(other);
        this.eventProperties = new Cloner().properties(other.getEventProperties());
    }

    public List<EventProperty> getEventProperties() {
        return this.eventProperties;
    }

    public void setEventProperties(List<EventProperty> eventProperties) {
        this.eventProperties = eventProperties;
    }

    public boolean addEventProperty(EventProperty p) {
        return this.eventProperties.add(p);
    }
}

