/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.staticproperty;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.staticproperty.Option;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyType;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/SelectionStaticProperty")
@MappedSuperclass
@Entity
public abstract class SelectionStaticProperty
extends StaticProperty {
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasOption")
    private List<Option> options;

    public SelectionStaticProperty(StaticPropertyType staticPropertyType) {
        super(staticPropertyType);
        this.options = new ArrayList<Option>();
    }

    public SelectionStaticProperty(SelectionStaticProperty other) {
        super(other);
        this.options = new Cloner().options(other.getOptions());
    }

    public SelectionStaticProperty(StaticPropertyType staticPropertyType, String internalName, String label, String description) {
        super(staticPropertyType, internalName, label, description);
        this.options = new ArrayList<Option>();
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public boolean addOption(Option option) {
        return this.options.add(option);
    }
}

