/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.template;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.template.BoundPipelineElement;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/PipelineTemplateDescription")
@Entity
public class PipelineTemplateDescription
extends NamedStreamPipesEntity {
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/isConnectedTo")
    private List<BoundPipelineElement> boundTo;

    public PipelineTemplateDescription() {
        this.boundTo = new ArrayList<BoundPipelineElement>();
    }

    public PipelineTemplateDescription(String uri, String name, String description) {
        super(uri, name, description);
        this.boundTo = new ArrayList<BoundPipelineElement>();
    }

    public PipelineTemplateDescription(SpDataStream requiredStream, List<BoundPipelineElement> connectedTo) {
        this.boundTo = connectedTo == null ? new ArrayList() : connectedTo;
    }

    public PipelineTemplateDescription(PipelineTemplateDescription other) {
        super(other);
        if (other.getBoundTo() != null) {
            this.boundTo = new Cloner().boundPipelineElements(other.getBoundTo());
        }
    }

    public PipelineTemplateDescription(String elementName, SpDataStream requiredStream, List<BoundPipelineElement> connectedTo) {
        super(elementName);
        this.boundTo = connectedTo;
    }

    public List<BoundPipelineElement> getBoundTo() {
        return this.boundTo;
    }

    public void setBoundTo(List<BoundPipelineElement> boundTo) {
        this.boundTo = boundTo;
    }

    public String getPipelineTemplateName() {
        return super.getName();
    }

    public void setPipelineTemplateName(String pipelineTemplateName) {
        super.setName(pipelineTemplateName);
    }

    public String getPipelineTemplateDescription() {
        return super.getDescription();
    }

    public void setPipelineTemplateDescription(String pipelineTemplateDescription) {
        super.setDescription(pipelineTemplateDescription);
    }

    public String getPipelineTemplateId() {
        return super.getElementId();
    }

    public void setPipelineTemplateId(String pipelineTemplateId) {
        super.setElementId(pipelineTemplateId);
        super.setAppId(pipelineTemplateId);
    }
}

