/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.template;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.UnnamedStreamPipesEntity;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.template.PipelineTemplateDescription;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/PipelineTemplateInvocation")
@Entity
public class PipelineTemplateInvocation
extends UnnamedStreamPipesEntity {
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasName")
    private String kviName;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasDataSetId")
    private String dataSetId;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/internalName")
    private String pipelineTemplateId;
    private PipelineTemplateDescription pipelineTemplateDescription;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasStaticProperty")
    private List<StaticProperty> staticProperties;

    public PipelineTemplateInvocation() {
        this.staticProperties = new ArrayList<StaticProperty>();
    }

    public PipelineTemplateInvocation(PipelineTemplateInvocation other) {
        super(other);
        this.kviName = other.getKviName();
        this.dataSetId = other.getDataSetId();
        this.pipelineTemplateId = other.getPipelineTemplateId();
        if (other.getStaticProperties() != null) {
            this.staticProperties = new Cloner().staticProperties(other.getStaticProperties());
        }
    }

    public String getKviName() {
        return this.kviName;
    }

    public void setKviName(String kviName) {
        this.kviName = kviName;
    }

    public String getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(String dataSetId) {
        this.dataSetId = dataSetId;
    }

    public List<StaticProperty> getStaticProperties() {
        return this.staticProperties;
    }

    public void setStaticProperties(List<StaticProperty> staticProperties) {
        this.staticProperties = staticProperties;
    }

    public PipelineTemplateDescription getPipelineTemplateDescription() {
        return this.pipelineTemplateDescription;
    }

    public void setPipelineTemplateDescription(PipelineTemplateDescription pipelineTemplateDescription) {
        this.pipelineTemplateDescription = pipelineTemplateDescription;
    }

    public String getPipelineTemplateId() {
        return this.pipelineTemplateId;
    }

    public void setPipelineTemplateId(String pipelineTemplateId) {
        this.pipelineTemplateId = pipelineTemplateId;
    }
}

