/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.model.ApplicationLink;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.grounding.JmsTransportProtocol;
import org.streampipes.model.grounding.KafkaTransportProtocol;
import org.streampipes.model.grounding.SimpleTopicDefinition;
import org.streampipes.model.grounding.TopicDefinition;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.model.grounding.WildcardTopicDefinition;
import org.streampipes.model.grounding.WildcardTopicMapping;
import org.streampipes.model.output.AppendOutputStrategy;
import org.streampipes.model.output.CustomOutputStrategy;
import org.streampipes.model.output.CustomTransformOutputStrategy;
import org.streampipes.model.output.FixedOutputStrategy;
import org.streampipes.model.output.KeepOutputStrategy;
import org.streampipes.model.output.ListOutputStrategy;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.output.TransformOperation;
import org.streampipes.model.output.TransformOutputStrategy;
import org.streampipes.model.quality.Accuracy;
import org.streampipes.model.quality.EventPropertyQualityDefinition;
import org.streampipes.model.quality.EventPropertyQualityRequirement;
import org.streampipes.model.quality.MeasurementCapability;
import org.streampipes.model.quality.MeasurementObject;
import org.streampipes.model.quality.Precision;
import org.streampipes.model.quality.Resolution;
import org.streampipes.model.schema.Enumeration;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.model.schema.QuantitativeValue;
import org.streampipes.model.schema.ValueSpecification;
import org.streampipes.model.staticproperty.AnyStaticProperty;
import org.streampipes.model.staticproperty.CollectionStaticProperty;
import org.streampipes.model.staticproperty.DomainStaticProperty;
import org.streampipes.model.staticproperty.FreeTextStaticProperty;
import org.streampipes.model.staticproperty.MappingPropertyNary;
import org.streampipes.model.staticproperty.MappingPropertyUnary;
import org.streampipes.model.staticproperty.MatchingStaticProperty;
import org.streampipes.model.staticproperty.OneOfStaticProperty;
import org.streampipes.model.staticproperty.Option;
import org.streampipes.model.staticproperty.RemoteOneOfStaticProperty;
import org.streampipes.model.staticproperty.RuntimeResolvableAnyStaticProperty;
import org.streampipes.model.staticproperty.RuntimeResolvableOneOfStaticProperty;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.SupportedProperty;
import org.streampipes.model.template.BoundPipelineElement;

public class Cloner {
    private final Logger LOG = LoggerFactory.getLogger(Cloner.class);

    public OutputStrategy outputStrategy(OutputStrategy other) {
        if (other instanceof KeepOutputStrategy) {
            return new KeepOutputStrategy((KeepOutputStrategy)other);
        }
        if (other instanceof FixedOutputStrategy) {
            return new FixedOutputStrategy((FixedOutputStrategy)other);
        }
        if (other instanceof ListOutputStrategy) {
            return new ListOutputStrategy((ListOutputStrategy)other);
        }
        if (other instanceof CustomOutputStrategy) {
            return new CustomOutputStrategy((CustomOutputStrategy)other);
        }
        if (other instanceof TransformOutputStrategy) {
            return new TransformOutputStrategy((TransformOutputStrategy)other);
        }
        if (other instanceof CustomTransformOutputStrategy) {
            return new CustomTransformOutputStrategy((CustomTransformOutputStrategy)other);
        }
        return new AppendOutputStrategy((AppendOutputStrategy)other);
    }

    public StaticProperty staticProperty(StaticProperty o) {
        if (o instanceof FreeTextStaticProperty) {
            return new FreeTextStaticProperty((FreeTextStaticProperty)o);
        }
        if (o instanceof OneOfStaticProperty) {
            return new OneOfStaticProperty((OneOfStaticProperty)o);
        }
        if (o instanceof RemoteOneOfStaticProperty) {
            return new RemoteOneOfStaticProperty((RemoteOneOfStaticProperty)o);
        }
        if (o instanceof MappingPropertyNary) {
            return new MappingPropertyNary((MappingPropertyNary)o);
        }
        if (o instanceof DomainStaticProperty) {
            return new DomainStaticProperty((DomainStaticProperty)o);
        }
        if (o instanceof AnyStaticProperty) {
            return new AnyStaticProperty((AnyStaticProperty)o);
        }
        if (o instanceof CollectionStaticProperty) {
            return new CollectionStaticProperty((CollectionStaticProperty)o);
        }
        if (o instanceof MatchingStaticProperty) {
            return new MatchingStaticProperty((MatchingStaticProperty)o);
        }
        if (o instanceof RuntimeResolvableOneOfStaticProperty) {
            return new RuntimeResolvableOneOfStaticProperty((RuntimeResolvableOneOfStaticProperty)o);
        }
        if (o instanceof RuntimeResolvableAnyStaticProperty) {
            return new RuntimeResolvableAnyStaticProperty((RuntimeResolvableAnyStaticProperty)o);
        }
        return new MappingPropertyUnary((MappingPropertyUnary)o);
    }

    public List<TransportProtocol> protocols(List<TransportProtocol> protocols) {
        return protocols.stream().map(o -> this.protocol((TransportProtocol)o)).collect(Collectors.toList());
    }

    public TransportProtocol protocol(TransportProtocol protocol) {
        if (protocol instanceof KafkaTransportProtocol) {
            return new KafkaTransportProtocol((KafkaTransportProtocol)protocol);
        }
        return new JmsTransportProtocol((JmsTransportProtocol)protocol);
    }

    public List<WildcardTopicMapping> wildcardTopics(List<WildcardTopicMapping> topicMappings) {
        if (topicMappings == null) {
            return new ArrayList<WildcardTopicMapping>();
        }
        return topicMappings.stream().map(t -> new WildcardTopicMapping((WildcardTopicMapping)t)).collect(Collectors.toList());
    }

    public EventProperty property(EventProperty o) {
        if (o instanceof EventPropertyPrimitive) {
            return new EventPropertyPrimitive((EventPropertyPrimitive)o);
        }
        if (o instanceof EventPropertyList) {
            return new EventPropertyList((EventPropertyList)o);
        }
        return new EventPropertyNested((EventPropertyNested)o);
    }

    public ValueSpecification valueSpecification(ValueSpecification o) {
        if (o instanceof QuantitativeValue) {
            return new QuantitativeValue((QuantitativeValue)o);
        }
        return new Enumeration((Enumeration)o);
    }

    public EventPropertyQualityRequirement qualityreq(EventPropertyQualityRequirement o) {
        return null;
    }

    public EventPropertyQualityDefinition qualitydef(EventPropertyQualityDefinition o) {
        if (o instanceof Accuracy) {
            return new Accuracy((Accuracy)o);
        }
        if (o instanceof Precision) {
            return new Precision((Precision)o);
        }
        return new Resolution((Resolution)o);
    }

    public List<SpDataStream> seq(List<SpDataStream> spDataStreams) {
        return spDataStreams.stream().map(s -> this.mapSequence((SpDataStream)s)).collect(Collectors.toList());
    }

    public List<SpDataStream> streams(List<SpDataStream> spDataStreams) {
        return spDataStreams.stream().map(s -> new SpDataStream((SpDataStream)s)).collect(Collectors.toList());
    }

    public SpDataStream mapSequence(SpDataStream seq) {
        if (seq instanceof SpDataSet) {
            return new SpDataSet((SpDataSet)seq);
        }
        return new SpDataStream(seq);
    }

    public SpDataStream stream(SpDataStream other) {
        return new SpDataStream(other);
    }

    public List<OutputStrategy> strategies(List<OutputStrategy> outputStrategies) {
        if (outputStrategies != null) {
            return outputStrategies.stream().map(o -> this.outputStrategy((OutputStrategy)o)).collect(Collectors.toList());
        }
        return new ArrayList<OutputStrategy>();
    }

    public List<StaticProperty> staticProperties(List<StaticProperty> staticProperties) {
        return staticProperties.stream().map(o -> this.staticProperty((StaticProperty)o)).collect(Collectors.toList());
    }

    public List<TransportFormat> transportFormats(List<TransportFormat> transportFormats) {
        return transportFormats.stream().map(t -> new TransportFormat((TransportFormat)t)).collect(Collectors.toList());
    }

    public List<EventProperty> properties(List<EventProperty> eventProperties) {
        return eventProperties.stream().map(o -> new Cloner().property((EventProperty)o)).collect(Collectors.toList());
    }

    public List<TransformOperation> transformOperations(List<TransformOperation> transformOperations) {
        return transformOperations.stream().map(o -> new TransformOperation((TransformOperation)o)).collect(Collectors.toList());
    }

    public List<EventPropertyQualityRequirement> reqEpQualitities(List<EventPropertyQualityRequirement> requiresEventPropertyQualities) {
        return requiresEventPropertyQualities.stream().map(o -> new Cloner().qualityreq((EventPropertyQualityRequirement)o)).collect(Collectors.toList());
    }

    public List<EventPropertyQualityDefinition> provEpQualities(List<EventPropertyQualityDefinition> eventPropertyQualities) {
        return eventPropertyQualities.stream().map(o -> new Cloner().qualitydef((EventPropertyQualityDefinition)o)).collect(Collectors.toList());
    }

    public List<Option> options(List<Option> options) {
        return options.stream().map(o -> new Option((Option)o)).collect(Collectors.toList());
    }

    public List<SupportedProperty> supportedProperties(List<SupportedProperty> supportedProperties) {
        return supportedProperties.stream().map(s -> new SupportedProperty((SupportedProperty)s)).collect(Collectors.toList());
    }

    public List<String> epaTypes(List<String> epaTypes) {
        return epaTypes;
    }

    public List<String> ecTypes(List<String> ecTypes) {
        return ecTypes;
    }

    public List<MeasurementCapability> mc(List<MeasurementCapability> measurementCapability) {
        return measurementCapability.stream().map(m -> new MeasurementCapability((MeasurementCapability)m)).collect(Collectors.toList());
    }

    public List<MeasurementObject> mo(List<MeasurementObject> measurementObject) {
        return measurementObject.stream().map(m -> new MeasurementObject((MeasurementObject)m)).collect(Collectors.toList());
    }

    public List<ApplicationLink> al(List<ApplicationLink> applicationLinks) {
        return applicationLinks.stream().map(m -> new ApplicationLink((ApplicationLink)m)).collect(Collectors.toList());
    }

    public TopicDefinition topicDefinition(TopicDefinition topicDefinition) {
        if (topicDefinition instanceof SimpleTopicDefinition) {
            return new SimpleTopicDefinition((SimpleTopicDefinition)topicDefinition);
        }
        return new WildcardTopicDefinition((WildcardTopicDefinition)topicDefinition);
    }

    public List<BoundPipelineElement> boundPipelineElements(List<BoundPipelineElement> boundPipelineElements) {
        return boundPipelineElements.stream().map(BoundPipelineElement::new).collect(Collectors.toList());
    }

    public List<NamedStreamPipesEntity> cloneDescriptions(List<NamedStreamPipesEntity> pipelineElementDescriptions) {
        return pipelineElementDescriptions.stream().map(pe -> this.cloneDescription((NamedStreamPipesEntity)pe)).collect(Collectors.toList());
    }

    private NamedStreamPipesEntity cloneDescription(NamedStreamPipesEntity pe) {
        if (pe instanceof SpDataSet) {
            return new SpDataSet((SpDataSet)pe);
        }
        if (pe instanceof SpDataStream) {
            return new SpDataStream((SpDataStream)pe);
        }
        if (pe instanceof DataProcessorDescription) {
            return new DataProcessorDescription((DataProcessorDescription)pe);
        }
        if (pe instanceof DataSinkDescription) {
            return new DataSinkDescription((DataSinkDescription)pe);
        }
        this.LOG.error("Description is of unknown type: " + pe.getClass().getCanonicalName());
        return pe;
    }
}

