/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.Rio;

public class ModelUtils {
    public static Class<?> getPrimitiveClass(String propertyType) {
        String xmlBaseURI = "http://www.w3.org/2001/XMLSchema#";
        if (propertyType.equals(xmlBaseURI + "string")) {
            return String.class;
        }
        if (propertyType.equals(xmlBaseURI + "double")) {
            return Double.class;
        }
        if (propertyType.equals(xmlBaseURI + "long")) {
            return Long.class;
        }
        if (propertyType.equals(xmlBaseURI + "integer")) {
            return Integer.class;
        }
        if (propertyType.equals(xmlBaseURI + "boolean")) {
            return Boolean.class;
        }
        if (propertyType.equals(xmlBaseURI + "float")) {
            return Float.class;
        }
        return null;
    }

    public static Class<?> getPrimitiveClassAsArray(String propertyType) {
        String xmlBaseURI = "http://www.w3.org/2001/XMLSchema#";
        if (propertyType.equals(xmlBaseURI + "string")) {
            return String[].class;
        }
        if (propertyType.equals(xmlBaseURI + "double")) {
            return Double[].class;
        }
        if (propertyType.equals(xmlBaseURI + "long")) {
            return Long[].class;
        }
        if (propertyType.equals(xmlBaseURI + "integer")) {
            return Integer[].class;
        }
        if (propertyType.equals(xmlBaseURI + "boolean")) {
            return Boolean[].class;
        }
        if (propertyType.equals(xmlBaseURI + "float")) {
            return Float[].class;
        }
        return null;
    }

    public static String asString(Graph graph) throws RDFHandlerException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Rio.write((Iterable)graph, (OutputStream)stream, (RDFFormat)RDFFormat.JSONLD);
        return ((Object)stream).toString();
    }

    public static List<Map<String, Object>> asList(Map<String, Object> map) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        result.add(map);
        return result;
    }
}

