/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.base;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.util.Cloner;

public abstract class ConsumableStreamPipesEntity
extends NamedStreamPipesEntity {
    private static final long serialVersionUID = -6617391345752016449L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/requiresStream")
    protected List<SpDataStream> spDataStreams;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasStaticProperty")
    protected List<StaticProperty> staticProperties;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/supportedGrounding")
    private EventGrounding supportedGrounding;

    public ConsumableStreamPipesEntity() {
        this.spDataStreams = new ArrayList<SpDataStream>();
        this.staticProperties = new ArrayList<StaticProperty>();
    }

    public ConsumableStreamPipesEntity(String uri, String name, String description, String iconUrl) {
        super(uri, name, description, iconUrl);
        this.spDataStreams = new ArrayList<SpDataStream>();
        this.staticProperties = new ArrayList<StaticProperty>();
    }

    public ConsumableStreamPipesEntity(ConsumableStreamPipesEntity other) {
        super(other);
        if (other.getSpDataStreams() != null) {
            this.spDataStreams = new Cloner().streams(other.getSpDataStreams());
        }
        this.staticProperties = new Cloner().staticProperties(other.getStaticProperties());
        if (other.getSupportedGrounding() != null) {
            this.supportedGrounding = new EventGrounding(other.getSupportedGrounding());
        }
    }

    public List<SpDataStream> getSpDataStreams() {
        return this.spDataStreams;
    }

    public void setSpDataStreams(List<SpDataStream> spDataStreams) {
        this.spDataStreams = spDataStreams;
    }

    public List<StaticProperty> getStaticProperties() {
        return this.staticProperties;
    }

    public void setStaticProperties(List<StaticProperty> staticProperties) {
        this.staticProperties = staticProperties;
    }

    public boolean addEventStream(SpDataStream spDataStream) {
        return this.spDataStreams.add(spDataStream);
    }

    public EventGrounding getSupportedGrounding() {
        return this.supportedGrounding;
    }

    public void setSupportedGrounding(EventGrounding supportedGrounding) {
        this.supportedGrounding = supportedGrounding;
    }
}

