/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.base;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.logging.LoggerFactory;
import org.streampipes.logging.api.Logger;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.monitoring.ElementStatusInfoSettings;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.util.Cloner;

public abstract class InvocableStreamPipesEntity
extends NamedStreamPipesEntity {
    private static final long serialVersionUID = 2727573914765473470L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/receivesStream")
    protected List<SpDataStream> inputStreams;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasStaticProperty")
    protected List<StaticProperty> staticProperties;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/belongsTo")
    private String belongsTo;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/statusInfoSettings")
    private ElementStatusInfoSettings statusInfoSettings;
    private EventGrounding supportedGrounding;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/correspondingPipeline")
    private String correspondingPipeline;
    private List<SpDataStream> streamRequirements;
    private boolean configured;

    public InvocableStreamPipesEntity() {
    }

    public InvocableStreamPipesEntity(InvocableStreamPipesEntity other) {
        super(other);
        this.belongsTo = other.getBelongsTo();
        this.correspondingPipeline = other.getCorrespondingPipeline();
        this.inputStreams = new Cloner().streams(other.getInputStreams());
        this.configured = other.isConfigured();
        if (other.getStreamRequirements() != null) {
            this.streamRequirements = new Cloner().streams(other.getStreamRequirements());
        }
        if (other.getStaticProperties() != null) {
            this.staticProperties = new Cloner().staticProperties(other.getStaticProperties());
        }
        this.DOM = other.getDOM();
        if (other.getSupportedGrounding() != null) {
            this.supportedGrounding = new EventGrounding(other.getSupportedGrounding());
        }
    }

    public InvocableStreamPipesEntity(String uri, String name, String description, String iconUrl) {
        super(uri, name, description, iconUrl);
        this.configured = false;
    }

    public boolean addStaticProperty(StaticProperty staticProperty) {
        return this.staticProperties.add(staticProperty);
    }

    public List<SpDataStream> getInputStreams() {
        return this.inputStreams;
    }

    public void setInputStreams(List<SpDataStream> inputStreams) {
        this.inputStreams = inputStreams;
    }

    public List<StaticProperty> getStaticProperties() {
        return this.staticProperties;
    }

    public void setStaticProperties(List<StaticProperty> staticProperties) {
        this.staticProperties = staticProperties;
    }

    public String getBelongsTo() {
        return this.belongsTo;
    }

    public void setBelongsTo(String belongsTo) {
        this.belongsTo = belongsTo;
    }

    public EventGrounding getSupportedGrounding() {
        return this.supportedGrounding;
    }

    public void setSupportedGrounding(EventGrounding supportedGrounding) {
        this.supportedGrounding = supportedGrounding;
    }

    public String getCorrespondingPipeline() {
        return this.correspondingPipeline;
    }

    public void setCorrespondingPipeline(String correspondingPipeline) {
        this.correspondingPipeline = correspondingPipeline;
    }

    public List<SpDataStream> getStreamRequirements() {
        return this.streamRequirements;
    }

    public void setStreamRequirements(List<SpDataStream> streamRequirements) {
        this.streamRequirements = streamRequirements;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public ElementStatusInfoSettings getStatusInfoSettings() {
        return this.statusInfoSettings;
    }

    public void setStatusInfoSettings(ElementStatusInfoSettings statusInfoSettings) {
        this.statusInfoSettings = statusInfoSettings;
    }

    public Logger getLogger(Class clazz) {
        return LoggerFactory.getPeLogger((Class)clazz, (String)this.getCorrespondingPipeline(), (String)this.getUri());
    }
}

