/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.connect.grounding;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.Namespaces;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.util.Cloner;

@Namespaces(value={"sp", "https://streampipes.org/vocabulary/v1/"})
@RdfsClass(value="sp:FormatDescription")
@Entity
public class FormatDescription
extends NamedStreamPipesEntity {
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="sp:config")
    private List<StaticProperty> config;

    public FormatDescription() {
        this.config = new ArrayList<StaticProperty>();
    }

    public FormatDescription(String uri, String name, String description) {
        super(uri, name, description);
        this.config = new ArrayList<StaticProperty>();
    }

    public FormatDescription(String uri, String name, String description, List<StaticProperty> config) {
        super(uri, name, description);
        this.config = config;
    }

    public FormatDescription(FormatDescription other) {
        super(other);
        this.config = new Cloner().staticProperties(other.getConfig());
    }

    public void addConfig(StaticProperty sp) {
        this.config.add(sp);
    }

    public List<StaticProperty> getConfig() {
        return this.config;
    }

    public void setConfig(List<StaticProperty> config) {
        this.config = config;
    }

    public String toString() {
        return "FormatDescription{config=" + this.config + '}';
    }
}

