/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.grounding;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.grounding.TopicDefinition;
import org.streampipes.model.grounding.WildcardTopicMapping;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/WildcardTopicDefinition")
@Entity
public class WildcardTopicDefinition
extends TopicDefinition {
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasWildcardTopicName")
    private String wildcardTopicName;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasWildcardTopicMapping")
    private List<WildcardTopicMapping> wildcardTopicMappings;

    public WildcardTopicDefinition() {
        this.wildcardTopicMappings = new ArrayList<WildcardTopicMapping>();
    }

    public WildcardTopicDefinition(WildcardTopicDefinition other) {
        super(other);
        this.wildcardTopicName = other.getWildcardTopicName();
        this.wildcardTopicMappings = new Cloner().wildcardTopics(other.getWildcardTopicMappings());
    }

    public WildcardTopicDefinition(String wildcardTopicName, List<WildcardTopicMapping> wildcardTopicMappings) {
        this.wildcardTopicMappings = wildcardTopicMappings;
        this.wildcardTopicName = wildcardTopicName;
    }

    public String getWildcardTopicName() {
        return this.wildcardTopicName;
    }

    public void setWildcardTopicName(String wildcardTopicName) {
        this.wildcardTopicName = wildcardTopicName;
    }

    public List<WildcardTopicMapping> getWildcardTopicMappings() {
        return this.wildcardTopicMappings;
    }

    public void setWildcardTopicMappings(List<WildcardTopicMapping> wildcardTopicMappings) {
        this.wildcardTopicMappings = wildcardTopicMappings;
    }
}

