/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.output;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/CustomOutputStrategy")
@Entity
public class CustomOutputStrategy
extends OutputStrategy {
    private static final long serialVersionUID = -5858193127308435472L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/producesProperty")
    private List<EventProperty> eventProperties;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/outputRight")
    private boolean outputRight;
    private List<EventProperty> providesProperties;

    public CustomOutputStrategy() {
        this.eventProperties = new ArrayList<EventProperty>();
    }

    public CustomOutputStrategy(boolean outputRight) {
        this.outputRight = outputRight;
        this.eventProperties = new ArrayList<EventProperty>();
    }

    public CustomOutputStrategy(CustomOutputStrategy other) {
        super(other);
        this.eventProperties = new Cloner().properties(other.getEventProperties());
        this.outputRight = other.isOutputRight();
    }

    public CustomOutputStrategy(List<EventProperty> eventProperties) {
        this.eventProperties = eventProperties;
    }

    public List<EventProperty> getEventProperties() {
        return this.eventProperties;
    }

    public void setEventProperties(List<EventProperty> eventProperties) {
        this.eventProperties = eventProperties;
    }

    public boolean isOutputRight() {
        return this.outputRight;
    }

    public void setOutputRight(boolean outputRight) {
        this.outputRight = outputRight;
    }

    public List<EventProperty> getProvidesProperties() {
        return this.providesProperties;
    }

    public void setProvidesProperties(List<EventProperty> providesProperties) {
        this.providesProperties = providesProperties;
    }
}

