/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.staticproperty;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyType;
import org.streampipes.model.staticproperty.SupportedProperty;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/DomainStaticProperty")
@Entity
public class DomainStaticProperty
extends StaticProperty {
    private static final long serialVersionUID = 1L;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/requiredClass")
    private String requiredClass;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasSupportedProperty")
    private List<SupportedProperty> supportedProperties;

    public DomainStaticProperty() {
        super(StaticPropertyType.DomainStaticProperty);
    }

    public DomainStaticProperty(String internalName, String label, String description, List<SupportedProperty> supportedProperties) {
        super(StaticPropertyType.DomainStaticProperty, internalName, label, description);
        this.supportedProperties = supportedProperties;
    }

    public DomainStaticProperty(String internalName, String label, String description, String requiredClass, List<SupportedProperty> supportedProperties) {
        this(internalName, label, description, supportedProperties);
        this.requiredClass = requiredClass;
    }

    public DomainStaticProperty(DomainStaticProperty other) {
        super(other);
        this.requiredClass = other.getRequiredClass();
        this.supportedProperties = new Cloner().supportedProperties(other.getSupportedProperties());
    }

    public String getRequiredClass() {
        return this.requiredClass;
    }

    public void setRequiredClass(String requiredClass) {
        this.requiredClass = requiredClass;
    }

    public List<SupportedProperty> getSupportedProperties() {
        return this.supportedProperties;
    }

    public void setSupportedProperties(List<SupportedProperty> supportedProperties) {
        this.supportedProperties = supportedProperties;
    }
}

