/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.staticproperty;

import java.net.URI;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.staticproperty.PropertyValueSpecification;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyType;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/FreeTextStaticProperty")
@Entity
public class FreeTextStaticProperty
extends StaticProperty {
    private static final long serialVersionUID = 1L;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasValue")
    private String value;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/requiresDatatype")
    private URI requiredDatatype;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/requiresDomainProperty")
    private URI requiredDomainProperty;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/mapsTo")
    private String mapsTo;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/multiLine")
    private boolean multiLine;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/htmlAllowed")
    private boolean htmlAllowed;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/placeholdersSupported")
    private boolean placeholdersSupported;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasValueSpecification")
    private PropertyValueSpecification valueSpecification;

    public FreeTextStaticProperty() {
        super(StaticPropertyType.FreeTextStaticProperty);
    }

    public FreeTextStaticProperty(FreeTextStaticProperty other) {
        super(other);
        this.requiredDomainProperty = other.getRequiredDomainProperty();
        this.requiredDatatype = other.getRequiredDatatype();
        if (other.getValueSpecification() != null) {
            this.valueSpecification = new PropertyValueSpecification(other.getValueSpecification());
        }
        this.value = other.getValue();
        this.htmlAllowed = other.isHtmlAllowed();
        this.multiLine = other.isMultiLine();
        this.placeholdersSupported = other.isPlaceholdersSupported();
        this.mapsTo = other.getMapsTo();
    }

    public FreeTextStaticProperty(String internalName, String label, String description) {
        super(StaticPropertyType.FreeTextStaticProperty, internalName, label, description);
    }

    public FreeTextStaticProperty(String internalName, String label, String description, URI type) {
        super(StaticPropertyType.FreeTextStaticProperty, internalName, label, description);
        this.requiredDomainProperty = type;
    }

    public FreeTextStaticProperty(String internalName, String label, String description, URI type, String mapsTo) {
        super(StaticPropertyType.FreeTextStaticProperty, internalName, label, description);
        this.mapsTo = mapsTo;
    }

    public FreeTextStaticProperty(String internalName, String label, String description, PropertyValueSpecification valueSpecification) {
        super(StaticPropertyType.FreeTextStaticProperty, internalName, label, description);
        this.valueSpecification = valueSpecification;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public URI getRequiredDomainProperty() {
        return this.requiredDomainProperty;
    }

    public void setRequiredDomainProperty(URI type) {
        this.requiredDomainProperty = type;
    }

    public PropertyValueSpecification getValueSpecification() {
        return this.valueSpecification;
    }

    public void setValueSpecification(PropertyValueSpecification valueSpecification) {
        this.valueSpecification = valueSpecification;
    }

    public URI getRequiredDatatype() {
        return this.requiredDatatype;
    }

    public void setRequiredDatatype(URI requiredDatatype) {
        this.requiredDatatype = requiredDatatype;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public boolean isHtmlAllowed() {
        return this.htmlAllowed;
    }

    public void setHtmlAllowed(boolean htmlAllowed) {
        this.htmlAllowed = htmlAllowed;
    }

    public boolean isPlaceholdersSupported() {
        return this.placeholdersSupported;
    }

    public void setPlaceholdersSupported(boolean placeholdersSupported) {
        this.placeholdersSupported = placeholdersSupported;
    }

    public String getMapsTo() {
        return this.mapsTo;
    }

    public void setMapsTo(String mapsTo) {
        this.mapsTo = mapsTo;
    }
}

