/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.model.util.ModelUtils;

public class PropertyUtils {
    public static Map<String, Object> getRuntimeFormat(EventProperty eventProperty) {
        return PropertyUtils.getUntypedRuntimeFormat(eventProperty);
    }

    public static Map<String, Object> getUntypedRuntimeFormat(EventProperty ep) {
        if (ep instanceof EventPropertyPrimitive) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(ep.getRuntimeName(), ModelUtils.getPrimitiveClass(((EventPropertyPrimitive)ep).getRuntimeType()));
            return result;
        }
        if (ep instanceof EventPropertyNested) {
            EventPropertyNested nestedEp = (EventPropertyNested)ep;
            HashMap<String, Object> propertyMap = new HashMap<String, Object>();
            HashMap<String, Object> subTypes = new HashMap<String, Object>();
            for (EventProperty p : nestedEp.getEventProperties()) {
                subTypes.putAll(PropertyUtils.getUntypedRuntimeFormat(p));
            }
            propertyMap.put(nestedEp.getRuntimeName(), subTypes);
            return propertyMap;
        }
        EventPropertyList listEp = (EventPropertyList)ep;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (EventProperty p : listEp.getEventProperties()) {
            if (p instanceof EventPropertyPrimitive && listEp.getEventProperties().size() == 1) {
                result.put(listEp.getRuntimeName(), ModelUtils.getPrimitiveClassAsArray(((EventPropertyPrimitive)p).getRuntimeType()));
                break;
            }
            result.put(listEp.getRuntimeName(), ModelUtils.asList(PropertyUtils.getUntypedRuntimeFormat(p)));
        }
        return result;
    }

    public static List<String> getFullPropertyName(EventProperty ep, String prefix) {
        if (ep instanceof EventPropertyPrimitive) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(prefix + ep.getRuntimeName());
            return result;
        }
        if (ep instanceof EventPropertyNested) {
            ArrayList<String> result = new ArrayList<String>();
            for (EventProperty p : ((EventPropertyNested)ep).getEventProperties()) {
                result.addAll(PropertyUtils.getFullPropertyName(p, ep.getRuntimeName() + "."));
            }
            return result;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(prefix + ep.getRuntimeName());
        return result;
    }
}

