/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/DataSourceDescription")
@Entity
public class DataSourceDescription
extends NamedStreamPipesEntity {
    private static final long serialVersionUID = 5607030219013954697L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/produces")
    private List<SpDataStream> spDataStreams;
    private String correspondingSourceId;

    public DataSourceDescription() {
        this.spDataStreams = new ArrayList<SpDataStream>();
    }

    public DataSourceDescription(DataSourceDescription other) {
        super(other);
        this.spDataStreams = new Cloner().seq(other.getSpDataStreams());
        this.spDataStreams.forEach(e -> e.setCategory(Arrays.asList(this.getElementId())));
    }

    public DataSourceDescription(String uri, String name, String description, String iconUrl, List<SpDataStream> spDataStreams) {
        super(uri, name, description, iconUrl);
        this.spDataStreams = spDataStreams;
        this.setAppId(uri);
    }

    public DataSourceDescription(String uri, String name2, String description2, String iconUrl) {
        this(uri, name2, description2, iconUrl, new ArrayList<SpDataStream>());
    }

    public DataSourceDescription(String uri, String name, String description) {
        this(uri, name, description, "", new ArrayList<SpDataStream>());
    }

    public List<SpDataStream> getSpDataStreams() {
        return this.spDataStreams;
    }

    public void setSpDataStreams(List<SpDataStream> spDataStreams) {
        this.spDataStreams = spDataStreams;
    }

    public void addEventStream(SpDataStream spDataStream) {
        this.spDataStreams.add(spDataStream);
    }

    public String getCorrespondingSourceId() {
        return this.correspondingSourceId;
    }

    public void setCorrespondingSourceId(String correspondingSourceId) {
        this.correspondingSourceId = correspondingSourceId;
    }
}

