/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.base;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfId;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.model.ApplicationLink;
import org.streampipes.model.base.AbstractStreamPipesEntity;
import org.streampipes.model.util.Cloner;

public abstract class NamedStreamPipesEntity
extends AbstractStreamPipesEntity {
    private static final long serialVersionUID = -98951691820519795L;
    @RdfProperty(value="http://www.w3.org/2000/01/rdf-schema#label")
    private String name;
    @RdfProperty(value="http://www.w3.org/2000/01/rdf-schema#description")
    private String description;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/iconUrl")
    private String iconUrl;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasUri")
    @RdfId
    protected String elementId;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasAppId")
    private String appId;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/includesAssets")
    private boolean includesAssets;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/includesLocales")
    private boolean includesLocales;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/includedAssets")
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<String> includedAssets;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/includedLocales")
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<String> includedLocales;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasApplicationLink")
    private List<ApplicationLink> applicationLinks;
    protected String DOM;
    protected List<String> connectedTo;

    public NamedStreamPipesEntity() {
        this.applicationLinks = new ArrayList<ApplicationLink>();
        this.includedAssets = new ArrayList<String>();
        this.includedLocales = new ArrayList<String>();
    }

    public NamedStreamPipesEntity(String elementId) {
        this();
        this.elementId = elementId;
    }

    public NamedStreamPipesEntity(String elementId, String name, String description, String iconUrl) {
        this(elementId, name, description);
        this.iconUrl = iconUrl;
    }

    public NamedStreamPipesEntity(String elementId, String name, String description) {
        this.elementId = elementId;
        this.name = name;
        this.description = description;
        this.applicationLinks = new ArrayList<ApplicationLink>();
        this.includedAssets = new ArrayList<String>();
        this.includedLocales = new ArrayList<String>();
    }

    public NamedStreamPipesEntity(NamedStreamPipesEntity other) {
        this.description = other.getDescription();
        this.name = other.getName();
        this.iconUrl = other.getIconUrl();
        this.elementId = other.getElementId();
        this.DOM = other.getDOM();
        this.connectedTo = other.getConnectedTo();
        if (other.getApplicationLinks() != null) {
            this.applicationLinks = new Cloner().al(other.getApplicationLinks());
        }
        this.appId = other.getAppId();
        this.includesAssets = other.isIncludesAssets();
        this.includesLocales = other.isIncludesLocales();
        if (other.getIncludedAssets() != null) {
            this.includedAssets = other.getIncludedAssets();
        }
        if (other.getIncludedLocales() != null) {
            this.includedLocales = other.getIncludedLocales();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @Deprecated
    public String getUri() {
        return this.elementId;
    }

    @Deprecated
    public void setUri(String uri) {
        this.elementId = uri;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setDOM(String DOM) {
        this.DOM = DOM;
    }

    public String getDOM() {
        return this.DOM;
    }

    public List<String> getConnectedTo() {
        return this.connectedTo;
    }

    public void setConnectedTo(List<String> connectedTo) {
        this.connectedTo = connectedTo;
    }

    public List<ApplicationLink> getApplicationLinks() {
        return this.applicationLinks;
    }

    public void setApplicationLinks(List<ApplicationLink> applicationLinks) {
        this.applicationLinks = applicationLinks;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public boolean isIncludesAssets() {
        return this.includesAssets;
    }

    public void setIncludesAssets(boolean includesAssets) {
        this.includesAssets = includesAssets;
    }

    public List<String> getIncludedAssets() {
        return this.includedAssets;
    }

    public void setIncludedAssets(List<String> includedAssets) {
        this.includedAssets = includedAssets;
    }

    public boolean isIncludesLocales() {
        return this.includesLocales;
    }

    public void setIncludesLocales(boolean includesLocales) {
        this.includesLocales = includesLocales;
    }

    public List<String> getIncludedLocales() {
        return this.includedLocales;
    }

    public void setIncludedLocales(List<String> includedLocales) {
        this.includedLocales = includedLocales;
    }

    @Deprecated
    public void changeElementId(String elementId) {
        this.elementId = elementId;
    }
}

