/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.connect.adapter;

import javax.persistence.Entity;
import org.streampipes.empire.annotations.Namespaces;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.connect.adapter.AdapterStreamDescription;
import org.streampipes.model.connect.adapter.GenericAdapterDescription;
import org.streampipes.model.connect.grounding.FormatDescription;
import org.streampipes.model.connect.grounding.ProtocolDescription;
import org.streampipes.model.connect.grounding.ProtocolStreamDescription;
import org.streampipes.model.schema.EventSchema;

@Namespaces(value={"sp", "https://streampipes.org/vocabulary/v1/"})
@RdfsClass(value="https://streampipes.org/vocabulary/v1/GenericAdapterStreamDescription")
@Entity
public class GenericAdapterStreamDescription
extends AdapterStreamDescription
implements GenericAdapterDescription {
    public static final String ID = "http://streampipes.org/genericadapterstreamdescription";
    @RdfProperty(value="sp:hasFormat")
    private FormatDescription formatDescription;
    @RdfProperty(value="sp:hasProtocol")
    private ProtocolDescription protocolDescription;

    public GenericAdapterStreamDescription() {
        super(ID, "GenericAdapterStreamDescription", "");
        this.setAdapterId(ID);
    }

    public GenericAdapterStreamDescription(FormatDescription formatDescription, ProtocolStreamDescription protocolDescription) {
        this.formatDescription = formatDescription;
        this.protocolDescription = protocolDescription;
    }

    public GenericAdapterStreamDescription(GenericAdapterStreamDescription other) {
        super(other);
        if (other.getFormatDescription() != null) {
            this.formatDescription = new FormatDescription(other.getFormatDescription());
        }
        if (other.getProtocolDescription() != null) {
            this.protocolDescription = new ProtocolStreamDescription(other.getProtocolDescription());
        }
    }

    @Override
    public FormatDescription getFormatDescription() {
        return this.formatDescription;
    }

    @Override
    public EventSchema getEventSchema() {
        if (this.getDataStream() != null) {
            return this.getDataStream().getEventSchema();
        }
        return null;
    }

    public void setFormatDescription(FormatDescription formatDescription) {
        this.formatDescription = formatDescription;
    }

    @Override
    public ProtocolDescription getProtocolDescription() {
        return this.protocolDescription;
    }

    public void setProtocolDescription(ProtocolDescription protocolDescription) {
        this.protocolDescription = protocolDescription;
    }
}

