/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.output;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.output.OutputStrategy;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/CustomOutputStrategy")
@Entity
public class CustomOutputStrategy
extends OutputStrategy {
    private static final long serialVersionUID = -5858193127308435472L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/producesProperty")
    private List<String> selectedPropertyKeys;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/outputRight")
    private boolean outputRight;
    private List<String> availablePropertyKeys;

    public CustomOutputStrategy() {
        this.selectedPropertyKeys = new ArrayList<String>();
        this.availablePropertyKeys = new ArrayList<String>();
    }

    public CustomOutputStrategy(boolean outputRight) {
        this();
        this.outputRight = outputRight;
    }

    public CustomOutputStrategy(CustomOutputStrategy other) {
        super(other);
        this.selectedPropertyKeys = other.getSelectedPropertyKeys();
        this.availablePropertyKeys = other.getAvailablePropertyKeys();
        this.outputRight = other.isOutputRight();
    }

    public CustomOutputStrategy(List<String> selectedPropertyKeys) {
        this();
        this.selectedPropertyKeys = selectedPropertyKeys;
    }

    public boolean isOutputRight() {
        return this.outputRight;
    }

    public void setOutputRight(boolean outputRight) {
        this.outputRight = outputRight;
    }

    public List<String> getSelectedPropertyKeys() {
        return this.selectedPropertyKeys;
    }

    public void setSelectedPropertyKeys(List<String> selectedPropertyKeys) {
        this.selectedPropertyKeys = selectedPropertyKeys;
    }

    public List<String> getAvailablePropertyKeys() {
        return this.availablePropertyKeys;
    }

    public void setAvailablePropertyKeys(List<String> availablePropertyKeys) {
        this.availablePropertyKeys = availablePropertyKeys;
    }
}

