/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.output;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.UnnamedStreamPipesEntity;
import org.streampipes.model.output.PropertyRenameRule;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/OutputStrategy")
@MappedSuperclass
@Entity
public abstract class OutputStrategy
extends UnnamedStreamPipesEntity {
    private static final long serialVersionUID = 1953204905003864143L;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasName")
    private String name;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasRenameRule")
    private List<PropertyRenameRule> renameRules;

    public OutputStrategy() {
        this.renameRules = new ArrayList<PropertyRenameRule>();
    }

    public OutputStrategy(OutputStrategy other) {
        super(other);
        this.name = other.getName();
        this.renameRules = new Cloner().renameRules(other.getRenameRules());
    }

    public OutputStrategy(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PropertyRenameRule> getRenameRules() {
        return this.renameRules;
    }

    public void setRenameRules(List<PropertyRenameRule> renameRules) {
        this.renameRules = renameRules;
    }
}

