/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.runtime;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.streampipes.model.output.PropertyRenameRule;
import org.streampipes.model.runtime.Event;
import org.streampipes.model.runtime.SchemaInfo;
import org.streampipes.model.runtime.SourceInfo;
import org.streampipes.model.runtime.field.AbstractField;
import org.streampipes.model.runtime.field.ListField;
import org.streampipes.model.runtime.field.NestedField;
import org.streampipes.model.runtime.field.PrimitiveField;
import org.streampipes.model.schema.EventSchema;

public class EventFactory {
    public static Event fromEvents(Event firstEvent, Event secondEvent, EventSchema outputSchema) {
        HashMap<String, AbstractField> fieldMap = new HashMap<String, AbstractField>();
        fieldMap.putAll(firstEvent.getFields());
        fieldMap.putAll(secondEvent.getFields());
        return new Event(fieldMap, EventFactory.makeMergedSourceInfo(), EventFactory.makeMergedSchemaInfo(firstEvent, secondEvent, outputSchema));
    }

    private static SourceInfo makeMergedSourceInfo() {
        return new SourceInfo(null, null);
    }

    private static SchemaInfo makeMergedSchemaInfo(Event firstEvent, Event secondEvent, EventSchema outputSchema) {
        ArrayList<PropertyRenameRule> propertyRenameRules = new ArrayList<PropertyRenameRule>();
        propertyRenameRules.addAll(firstEvent.getSchemaInfo().getRenameRules());
        propertyRenameRules.addAll(secondEvent.getSchemaInfo().getRenameRules());
        return new SchemaInfo(outputSchema, propertyRenameRules);
    }

    public static Event fromMap(Map<String, Object> event) {
        SourceInfo sourceInfo = new SourceInfo("o", "o");
        SchemaInfo schemaInfo = new SchemaInfo(null, new ArrayList<PropertyRenameRule>());
        return EventFactory.fromMap(event, sourceInfo, schemaInfo);
    }

    public static Event fromMap(Map<String, Object> event, SourceInfo sourceInfo, SchemaInfo schemaInfo) {
        LinkedTreeMap fields = new LinkedTreeMap();
        for (String key : event.keySet()) {
            String currentSelector = EventFactory.makeSelector(key, sourceInfo.getSelectorPrefix());
            fields.put(currentSelector, EventFactory.makeField(key, event.get(key), currentSelector, schemaInfo));
        }
        return new Event((Map<String, AbstractField>)fields, sourceInfo, schemaInfo);
    }

    public static Event makeSubset(Event event, List<String> fieldSelectors) {
        Map<String, AbstractField> fieldMap = EventFactory.makeFieldMap(event.getFields(), fieldSelectors);
        return new Event(fieldMap, event.getSourceInfo(), event.getSchemaInfo());
    }

    private static Map<String, Object> makeRuntimeMapSubset(Map<String, Object> event, List<String> fieldSelectors, String currentPrefix) {
        HashMap<String, Object> outMap = new HashMap<String, Object>();
        for (String key : event.keySet()) {
            if (!EventFactory.contains(EventFactory.makeSelector(key, currentPrefix), fieldSelectors)) continue;
            Object object = event.get(key);
            if (Map.class.isInstance(object)) {
                Map map = (Map)object;
                map.put(key, EventFactory.makeRuntimeMapSubset(map, fieldSelectors, EventFactory.makeSelector(key, currentPrefix)));
                continue;
            }
            outMap.put(key, object);
        }
        return outMap;
    }

    private static Map<String, AbstractField> makeFieldMap(Map<String, AbstractField> fields, List<String> fieldSelectors) {
        HashMap<String, AbstractField> outMap = new HashMap<String, AbstractField>();
        for (String key : fields.keySet()) {
            if (!EventFactory.contains(key, fieldSelectors)) continue;
            AbstractField field = fields.get(key);
            if (PrimitiveField.class.isInstance(field) || ListField.class.isInstance(field)) {
                outMap.put(key, field);
                continue;
            }
            field.getAsComposite().setValue(EventFactory.makeFieldMap((Map)field.getAsComposite().getRawValue(), fieldSelectors));
            outMap.put(key, field);
        }
        return outMap;
    }

    private static boolean contains(String key, List<String> fieldSelectors) {
        return fieldSelectors.stream().anyMatch(f -> f.equals(key));
    }

    private static AbstractField makeField(String runtimeName, Object o, String currentSelector, SchemaInfo schemaInfo) {
        if (Map.class.isInstance(o)) {
            Map items = (Map)o;
            LinkedTreeMap fieldMap = new LinkedTreeMap();
            for (String key : items.keySet()) {
                String selector = EventFactory.makeSelector(key, currentSelector);
                fieldMap.put(selector, EventFactory.makeField(key, items.get(key), selector, schemaInfo));
            }
            return new NestedField(runtimeName, EventFactory.getNewRuntimeName(currentSelector, runtimeName, schemaInfo.getRenameRules()), (Map<String, AbstractField>)fieldMap);
        }
        if (List.class.isInstance(o)) {
            ArrayList<AbstractField> items = new ArrayList<AbstractField>();
            Integer i = 0;
            while (i < ((List)o).size()) {
                items.add(EventFactory.makeField("", ((List)o).get(i), currentSelector + "::" + i, schemaInfo));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return new ListField(runtimeName, EventFactory.getNewRuntimeName(currentSelector, runtimeName, schemaInfo.getRenameRules()), (List<AbstractField>)items);
        }
        return new PrimitiveField(runtimeName, EventFactory.getNewRuntimeName(currentSelector, runtimeName, schemaInfo.getRenameRules()), o);
    }

    private static String getNewRuntimeName(String currentSelector, String runtimeName, List<PropertyRenameRule> renameRules) {
        return renameRules.stream().filter(r -> r.getRuntimeId().equals(currentSelector)).findFirst().map(PropertyRenameRule::getNewRuntimeName).orElse(runtimeName);
    }

    private static String makeSelector(String key, String selectorPrefix) {
        return selectorPrefix + "::" + key;
    }
}

