/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.runtime.field;

import com.github.drapostolos.typeparser.TypeParser;
import org.streampipes.model.runtime.field.FieldParser;
import org.streampipes.model.runtime.field.ListField;
import org.streampipes.model.runtime.field.NestedField;
import org.streampipes.model.runtime.field.PrimitiveField;

public abstract class AbstractField<FV> {
    protected String fieldNameIn;
    protected String fieldNameOut;
    protected FV value;
    protected TypeParser typeParser = TypeParser.newBuilder().build();

    public AbstractField(String fieldNameIn, String fieldNameOut, FV value) {
        this(fieldNameIn);
        this.value = value;
        this.fieldNameOut = fieldNameOut;
    }

    public AbstractField(String fieldNameIn) {
        this();
        this.fieldNameIn = fieldNameIn;
        this.fieldNameOut = fieldNameIn;
    }

    public AbstractField() {
    }

    protected String asString(Object field) {
        return String.valueOf(field);
    }

    public String getFieldNameIn() {
        return this.fieldNameIn;
    }

    public String getFieldNameOut() {
        return this.fieldNameOut;
    }

    public Boolean isComposite() {
        return this.isInstance(NestedField.class);
    }

    public Boolean isList() {
        return this.isInstance(ListField.class);
    }

    public Boolean isPrimitive() {
        return this.isInstance(PrimitiveField.class);
    }

    private Boolean isInstance(Class<? extends AbstractField> clazz) {
        return clazz.isInstance(this);
    }

    public NestedField getAsComposite() {
        return (NestedField)this;
    }

    public ListField getAsList() {
        return (ListField)this;
    }

    public PrimitiveField getAsPrimitive() {
        return (PrimitiveField)this;
    }

    public FV getRawValue() {
        return this.value;
    }

    public <T> T parse(FieldParser<FV, T> fieldParser) {
        return fieldParser.parseField(this.value);
    }

    public void setValue(FV value) {
        this.value = value;
    }

    public void rename(String newFieldName) {
        this.fieldNameIn = newFieldName;
        this.fieldNameOut = newFieldName;
    }
}

