/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.runtime.field;

import java.util.HashMap;
import java.util.Map;
import org.streampipes.model.runtime.field.AbstractField;
import org.streampipes.model.runtime.field.PrimitiveField;

public class NestedField
extends AbstractField<Map<String, AbstractField>> {
    private Boolean hasKey;

    public NestedField(String fieldNameIn, String fieldNameOut, Map<String, AbstractField> value) {
        super(fieldNameIn, fieldNameOut, value);
        this.hasKey = true;
    }

    public NestedField(String fieldNameIn, Boolean hasKey) {
        super(fieldNameIn);
        this.hasKey = hasKey;
        this.value = new HashMap();
    }

    public NestedField() {
        this.value = new HashMap();
    }

    public AbstractField getFieldByRuntimeName(String runtimeName) {
        return (AbstractField)((Map)this.value).get(runtimeName);
    }

    public void addField(String key, AbstractField field) {
        ((Map)this.value).put(key, field);
    }

    public void addField(String runtimeName, Integer value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, Long value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, Object value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, Float value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, Double value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, Boolean value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, String value) {
        this.addPrimitive(runtimeName, value);
    }

    private void addPrimitive(String runtimeName, Object value) {
        ((Map)this.value).put(runtimeName, new PrimitiveField(runtimeName, runtimeName, value));
    }

    public Boolean getHasKey() {
        return this.hasKey;
    }
}

