/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.schema;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.UnnamedStreamPipesEntity;
import org.streampipes.model.quality.EventPropertyQualityDefinition;
import org.streampipes.model.quality.EventPropertyQualityRequirement;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/EventProperty")
@MappedSuperclass
@Entity
public abstract class EventProperty
extends UnnamedStreamPipesEntity {
    private static final long serialVersionUID = 7079045979946059387L;
    protected static final String prefix = "urn:streampipes.org:spi:";
    @RdfProperty(value="http://www.w3.org/2000/01/rdf-schema#label")
    private String label;
    @RdfProperty(value="http://www.w3.org/2000/01/rdf-schema#description")
    private String description;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasRuntimeName")
    private String runtimeName;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/required")
    private boolean required;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/domainProperty")
    private List<URI> domainProperties;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEventPropertyQualityDefinition")
    private List<EventPropertyQualityDefinition> eventPropertyQualities;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEventPropertyQualityRequirement")
    private List<EventPropertyQualityRequirement> requiresEventPropertyQualities;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasPropertyScope")
    private String propertyScope;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasIndex")
    private int index = 0;
    private String runtimeId;

    public EventProperty() {
        super(prefix + UUID.randomUUID().toString());
        this.requiresEventPropertyQualities = new ArrayList<EventPropertyQualityRequirement>();
        this.eventPropertyQualities = new ArrayList<EventPropertyQualityDefinition>();
    }

    public EventProperty(EventProperty other) {
        super(other);
        this.label = other.getLabel();
        this.description = other.getDescription();
        this.required = other.isRequired();
        if (other.getRequiresEventPropertyQualities() != null) {
            this.requiresEventPropertyQualities = new Cloner().reqEpQualitities(other.getRequiresEventPropertyQualities());
        }
        this.runtimeName = other.getRuntimeName();
        if (other.getEventPropertyQualities() != null) {
            this.eventPropertyQualities = new Cloner().provEpQualities(other.getEventPropertyQualities());
        }
        this.domainProperties = other.getDomainProperties();
        this.propertyScope = other.getPropertyScope();
        this.runtimeId = other.getRuntimeId();
        this.index = other.getIndex();
    }

    public EventProperty(List<URI> subClassOf) {
        this();
        this.domainProperties = subClassOf;
    }

    public EventProperty(String propertyName, List<URI> subClassOf) {
        this();
        this.runtimeName = propertyName;
        this.domainProperties = subClassOf;
    }

    public EventProperty(String propertyName, List<URI> subClassOf, List<EventPropertyQualityDefinition> eventPropertyQualities) {
        this();
        this.runtimeName = propertyName;
        this.domainProperties = subClassOf;
        this.eventPropertyQualities = eventPropertyQualities;
    }

    public EventProperty(String propertyName) {
        this();
        this.runtimeName = propertyName;
    }

    public List<EventPropertyQualityRequirement> getRequiresEventPropertyQualities() {
        return this.requiresEventPropertyQualities;
    }

    public void setRequiresEventPropertyQualities(List<EventPropertyQualityRequirement> requiresEventPropertyQualities) {
        this.requiresEventPropertyQualities = requiresEventPropertyQualities;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public void setRuntimeName(String propertyName) {
        this.runtimeName = propertyName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public List<URI> getDomainProperties() {
        return this.domainProperties;
    }

    public void setDomainProperties(List<URI> subClassOf) {
        this.domainProperties = subClassOf;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String humanReadableTitle) {
        this.label = humanReadableTitle;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String humanReadableDescription) {
        this.description = humanReadableDescription;
    }

    public List<EventPropertyQualityDefinition> getEventPropertyQualities() {
        return this.eventPropertyQualities;
    }

    public void setEventPropertyQualities(List<EventPropertyQualityDefinition> eventPropertyQualities) {
        this.eventPropertyQualities = eventPropertyQualities;
    }

    public String getPropertyScope() {
        return this.propertyScope;
    }

    public void setPropertyScope(String propertyScope) {
        this.propertyScope = propertyScope;
    }

    public static String getPrefix() {
        return prefix;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public void setRuntimeId(String runtimeId) {
        this.runtimeId = runtimeId;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

