/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.schema;

import java.net.URI;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.quality.EventPropertyQualityDefinition;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.ValueSpecification;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/EventPropertyPrimitive")
@Entity
public class EventPropertyPrimitive
extends EventProperty {
    private static final long serialVersionUID = 665989638281665875L;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasPropertyType")
    private String runtimeType;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasMeasurementUnit")
    @OneToOne(cascade={CascadeType.ALL})
    private URI measurementUnit;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasValueSpecification")
    @OneToOne(cascade={CascadeType.ALL})
    private ValueSpecification valueSpecification;

    public EventPropertyPrimitive() {
    }

    public EventPropertyPrimitive(EventPropertyPrimitive other) {
        super(other);
        this.runtimeType = other.getRuntimeType();
        this.measurementUnit = other.getMeasurementUnit();
        if (other.getValueSpecification() != null) {
            this.valueSpecification = new Cloner().valueSpecification(other.getValueSpecification());
        }
    }

    public EventPropertyPrimitive(List<URI> subClassOf) {
        super(subClassOf);
    }

    public EventPropertyPrimitive(String runtimeType, String runtimeName, String measurementUnit, List<URI> subClassOf) {
        super(runtimeName, subClassOf);
        this.runtimeType = runtimeType;
    }

    public EventPropertyPrimitive(String propertyType, String propertyName, String measurementUnit, List<URI> subClassOf, List<EventPropertyQualityDefinition> qualities) {
        super(propertyName, subClassOf, qualities);
        this.runtimeType = propertyType;
    }

    public String getRuntimeType() {
        return this.runtimeType;
    }

    public void setRuntimeType(String propertyType) {
        this.runtimeType = propertyType;
    }

    public URI getMeasurementUnit() {
        return this.measurementUnit;
    }

    public void setMeasurementUnit(URI measurementUnit) {
        this.measurementUnit = measurementUnit;
    }

    public ValueSpecification getValueSpecification() {
        return this.valueSpecification;
    }

    public void setValueSpecification(ValueSpecification valueSpecification) {
        this.valueSpecification = valueSpecification;
    }
}

