/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.staticproperty;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyType;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/StaticPropertyAlternative")
@Entity
public class StaticPropertyAlternative
extends StaticProperty {
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/isSelected")
    private Boolean selected;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasStaticProperty")
    private StaticProperty staticProperty;

    public StaticPropertyAlternative() {
        super(StaticPropertyType.StaticPropertyAlternative);
    }

    public StaticPropertyAlternative(String internalName, String label, String description) {
        super(StaticPropertyType.StaticPropertyAlternative, internalName, label, description);
    }

    public StaticPropertyAlternative(StaticPropertyAlternative other) {
        super(other);
        this.selected = other.getSelected();
        if (other.getStaticProperty() != null) {
            this.staticProperty = new Cloner().staticProperty(other.getStaticProperty());
        }
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public StaticProperty getStaticProperty() {
        return this.staticProperty;
    }

    public void setStaticProperty(StaticProperty staticProperty) {
        this.staticProperty = staticProperty;
    }
}

