/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.staticproperty;

import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyAlternative;
import org.streampipes.model.staticproperty.StaticPropertyType;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/StaticPropertyAlternatives")
@Entity
public class StaticPropertyAlternatives
extends StaticProperty {
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasStaticPropertyAlternative")
    private List<StaticPropertyAlternative> alternatives;

    public StaticPropertyAlternatives() {
        super(StaticPropertyType.StaticPropertyAlternatives);
    }

    public StaticPropertyAlternatives(StaticPropertyAlternatives other) {
        super(other);
        this.alternatives = other.getAlternatives().stream().map(StaticPropertyAlternative::new).collect(Collectors.toList());
    }

    public StaticPropertyAlternatives(String internalName, String label, String description) {
        super(StaticPropertyType.StaticPropertyAlternatives, internalName, label, description);
    }

    public List<StaticPropertyAlternative> getAlternatives() {
        return this.alternatives;
    }

    public void setAlternatives(List<StaticPropertyAlternative> alternatives) {
        this.alternatives = alternatives;
    }
}

