/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.lang.RandomStringUtils;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.quality.EventStreamQualityDefinition;
import org.streampipes.model.quality.EventStreamQualityRequirement;
import org.streampipes.model.quality.MeasurementCapability;
import org.streampipes.model.quality.MeasurementObject;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/DataStream")
@Entity
public class SpDataStream
extends NamedStreamPipesEntity {
    private static final long serialVersionUID = -5732549347563182863L;
    private static final String prefix = "urn:fzi.de:eventstream:";
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEventStreamQualityDefinition")
    protected transient List<EventStreamQualityDefinition> hasEventStreamQualities;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasEventStreamQualityRequirement")
    protected transient List<EventStreamQualityRequirement> requiresEventStreamQualities;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasGrounding")
    protected EventGrounding eventGrounding;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasSchema")
    protected EventSchema eventSchema;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasMeasurementCapability")
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    protected List<MeasurementCapability> measurementCapability;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasMeasurementObject")
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    protected List<MeasurementObject> measurementObject;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasIndex")
    private int index;
    protected List<String> category;

    public SpDataStream(String uri, String name, String description, String iconUrl, List<EventStreamQualityDefinition> hasEventStreamQualities, EventGrounding eventGrounding, EventSchema eventSchema) {
        super(uri, name, description, iconUrl);
        this.hasEventStreamQualities = hasEventStreamQualities;
        this.eventGrounding = eventGrounding;
        this.eventSchema = eventSchema;
    }

    public SpDataStream(String uri, String name, String description, EventSchema eventSchema) {
        super(uri, name, description);
        this.eventSchema = eventSchema;
    }

    public SpDataStream() {
        super(prefix + RandomStringUtils.randomAlphabetic((int)6));
    }

    public SpDataStream(SpDataStream other) {
        super(other);
        this.index = other.getIndex();
        if (other.getEventGrounding() != null) {
            this.eventGrounding = new EventGrounding(other.getEventGrounding());
        }
        if (other.getEventSchema() != null) {
            this.eventSchema = new EventSchema(other.getEventSchema());
        }
        if (other.getHasEventStreamQualities() != null) {
            this.hasEventStreamQualities = other.getHasEventStreamQualities().stream().map(EventStreamQualityDefinition::new).collect(Collectors.toCollection(ArrayList::new));
        }
        if (other.getRequiresEventStreamQualities() != null) {
            this.requiresEventStreamQualities = other.getRequiresEventStreamQualities().stream().map(EventStreamQualityRequirement::new).collect(Collectors.toCollection(ArrayList::new));
        }
        if (other.getMeasurementCapability() != null) {
            this.measurementCapability = new Cloner().mc(other.getMeasurementCapability());
        }
        if (other.getMeasurementObject() != null) {
            this.measurementObject = new Cloner().mo(other.getMeasurementObject());
        }
    }

    public List<EventStreamQualityDefinition> getHasEventStreamQualities() {
        return this.hasEventStreamQualities;
    }

    public void setHasEventStreamQualities(List<EventStreamQualityDefinition> hasEventStreamQualities) {
        this.hasEventStreamQualities = hasEventStreamQualities;
    }

    public List<EventStreamQualityRequirement> getRequiresEventStreamQualities() {
        return this.requiresEventStreamQualities;
    }

    public void setRequiresEventStreamQualities(List<EventStreamQualityRequirement> requiresEventStreamQualities) {
        this.requiresEventStreamQualities = requiresEventStreamQualities;
    }

    public EventSchema getEventSchema() {
        return this.eventSchema;
    }

    public void setEventSchema(EventSchema eventSchema) {
        this.eventSchema = eventSchema;
    }

    public EventGrounding getEventGrounding() {
        return this.eventGrounding;
    }

    public void setEventGrounding(EventGrounding eventGrounding) {
        this.eventGrounding = eventGrounding;
    }

    public List<MeasurementCapability> getMeasurementCapability() {
        return this.measurementCapability;
    }

    public void setMeasurementCapability(List<MeasurementCapability> measurementCapability) {
        this.measurementCapability = measurementCapability;
    }

    public List<MeasurementObject> getMeasurementObject() {
        return this.measurementObject;
    }

    public void setMeasurementObject(List<MeasurementObject> measurementObject) {
        this.measurementObject = measurementObject;
    }

    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

