/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.connect.adapter;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.Namespaces;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.connect.rules.Schema.SchemaTransformationRuleDescription;
import org.streampipes.model.connect.rules.Stream.StreamTransformationRuleDescription;
import org.streampipes.model.connect.rules.TransformationRuleDescription;
import org.streampipes.model.connect.rules.value.ValueTransformationRuleDescription;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.grounding.KafkaTransportProtocol;
import org.streampipes.model.grounding.SimpleTopicDefinition;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.util.Cloner;

@Namespaces(value={"sp", "https://streampipes.org/vocabulary/v1/"})
@RdfsClass(value="sp:AdapterDescription")
@Entity
public abstract class AdapterDescription
extends NamedStreamPipesEntity {
    @RdfProperty(value="sp:couchDBId")
    @SerializedName(value="_id")
    private String id;
    @SerializedName(value="_rev")
    private String rev;
    @RdfProperty(value="sp:adapterId")
    private String adapterId;
    @RdfProperty(value="sp:userName")
    private String userName;
    @RdfProperty(value="sp:grounding")
    private EventGrounding eventGrounding;
    @RdfProperty(value="sp:adapterType")
    private String adapterType;
    @RdfProperty(value="sp:icon")
    private String icon;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="sp:config")
    private List<StaticProperty> config;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="sp:rules")
    private List<TransformationRuleDescription> rules;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasAdapterType")
    private List<String> category;

    public AdapterDescription() {
        this.rules = new ArrayList<TransformationRuleDescription>();
        this.eventGrounding = new EventGrounding();
        this.config = new ArrayList<StaticProperty>();
        this.category = new ArrayList<String>();
        KafkaTransportProtocol tp = new KafkaTransportProtocol();
        tp.setTopicDefinition(new SimpleTopicDefinition("bb"));
        this.eventGrounding.setTransportProtocol(tp);
    }

    public AdapterDescription(String uri, String name, String description) {
        super(uri, name, description);
        this.rules = new ArrayList<TransformationRuleDescription>();
        this.category = new ArrayList<String>();
    }

    public AdapterDescription(AdapterDescription other) {
        super(other);
        this.adapterId = other.getAdapterId();
        this.config = new Cloner().staticProperties(other.getConfig());
        this.userName = other.getUserName();
        this.rules = other.getRules();
        this.adapterType = other.getAdapterType();
        this.icon = other.getIcon();
        this.category = new Cloner().epaTypes(other.getCategory());
        if (other.getEventGrounding() != null) {
            this.eventGrounding = new EventGrounding(other.getEventGrounding());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<TransformationRuleDescription> getRules() {
        return this.rules;
    }

    public void setRules(List<TransformationRuleDescription> rules) {
        this.rules = rules;
    }

    public EventGrounding getEventGrounding() {
        return this.eventGrounding;
    }

    public void setEventGrounding(EventGrounding eventGrounding) {
        this.eventGrounding = eventGrounding;
    }

    public List<StaticProperty> getConfig() {
        return this.config;
    }

    public void addConfig(StaticProperty sp) {
        this.config.add(sp);
    }

    public void setConfig(List<StaticProperty> config) {
        this.config = config;
    }

    public String getAdapterType() {
        return this.adapterType;
    }

    public void setAdapterType(String adapterType) {
        this.adapterType = adapterType;
    }

    public List getValueRules() {
        ArrayList tmp = new ArrayList();
        this.rules.forEach(rule -> {
            if (rule instanceof ValueTransformationRuleDescription) {
                tmp.add(rule);
            }
        });
        return tmp;
    }

    public List getStreamRules() {
        ArrayList tmp = new ArrayList();
        this.rules.forEach(rule -> {
            if (rule instanceof StreamTransformationRuleDescription) {
                tmp.add(rule);
            }
        });
        return tmp;
    }

    public List getSchemaRules() {
        ArrayList tmp = new ArrayList();
        this.rules.forEach(rule -> {
            if (rule instanceof SchemaTransformationRuleDescription) {
                tmp.add(rule);
            }
        });
        return tmp;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }

    public String toString() {
        return "AdapterDescription{id='" + this.id + '\'' + ", rev='" + this.rev + '\'' + ", elementId='" + this.elementId + '\'' + ", DOM='" + this.DOM + '\'' + '}';
    }
}

