/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.connect.grounding;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.Namespaces;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.util.Cloner;

@Namespaces(value={"sp", "https://streampipes.org/vocabulary/v1/"})
@RdfsClass(value="sp:ProtocolDescription")
@Entity
public class ProtocolDescription
extends NamedStreamPipesEntity {
    @Deprecated
    @RdfProperty(value="sp:sourceType")
    String sourceType;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="sp:config")
    List<StaticProperty> config;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasAdapterType")
    private List<String> category;

    public ProtocolDescription() {
    }

    public ProtocolDescription(String uri, String name, String description) {
        super(uri, name, description);
        this.config = new ArrayList<StaticProperty>();
        this.category = new ArrayList<String>();
    }

    public ProtocolDescription(String uri, String name, String description, List<StaticProperty> config) {
        super(uri, name, description);
        this.config = config;
        this.category = new ArrayList<String>();
    }

    public ProtocolDescription(ProtocolDescription other) {
        super(other);
        this.config = new Cloner().staticProperties(other.getConfig());
        if (other.getCategory() != null) {
            this.category = new Cloner().epaTypes(other.getCategory());
        }
    }

    public void addConfig(StaticProperty sp) {
        this.config.add(sp);
    }

    public List<StaticProperty> getConfig() {
        return this.config;
    }

    public void setConfig(List<StaticProperty> config) {
        this.config = config;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }
}

