/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.grounding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.base.UnnamedStreamPipesEntity;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/DataStreamGrounding")
@Entity
public class EventGrounding
extends UnnamedStreamPipesEntity {
    private static final long serialVersionUID = 3149070517282698799L;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasTransportProtocol")
    private List<TransportProtocol> transportProtocols;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasTransportFormat")
    private List<TransportFormat> transportFormats;

    public EventGrounding() {
        this.transportFormats = new ArrayList<TransportFormat>();
    }

    public EventGrounding(TransportProtocol transportProtocol, TransportFormat transportFormat) {
        this();
        this.transportFormats = new ArrayList<TransportFormat>();
        this.transportFormats.add(transportFormat);
        this.transportProtocols = Arrays.asList(transportProtocol);
    }

    public EventGrounding(EventGrounding other) {
        super(other);
        this.transportProtocols = new Cloner().protocols(other.getTransportProtocols());
        this.transportFormats = new Cloner().transportFormats(other.getTransportFormats());
    }

    public List<TransportProtocol> getTransportProtocols() {
        return this.transportProtocols;
    }

    public void setTransportProtocols(List<TransportProtocol> transportProtocols) {
        this.transportProtocols = transportProtocols;
    }

    public void setTransportProtocol(TransportProtocol transportProtocol) {
        this.transportProtocols = Collections.singletonList(transportProtocol);
    }

    public TransportProtocol getTransportProtocol() {
        return this.transportProtocols.get(0);
    }

    public List<TransportFormat> getTransportFormats() {
        return this.transportFormats;
    }

    public void setTransportFormats(List<TransportFormat> transportFormats) {
        this.transportFormats = transportFormats;
    }
}

