/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.grounding;

import javax.persistence.Entity;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.grounding.SimpleTopicDefinition;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.model.grounding.WildcardTopicDefinition;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/KafkaTransportProtocol")
@Entity
public class KafkaTransportProtocol
extends TransportProtocol {
    private static final long serialVersionUID = -4067982203807146257L;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/zookeeperHost")
    private String zookeeperHost;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/zookeeperPort")
    private int zookeeperPort;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/kafkaPort")
    private int kafkaPort;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/kafkaLingerMs")
    private Integer lingerMs;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/kafkaMessageMaxBytes")
    private String messageMaxBytes;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/kafkaAcks")
    private String acks;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/kafkaBatchSize")
    private String batchSize;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/kafkaOffset")
    private String offset;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/kafkaGroupId")
    private String groupId;

    public KafkaTransportProtocol(String kafkaHost, int kafkaPort, String topic) {
        super(kafkaHost, new SimpleTopicDefinition(topic));
        this.zookeeperHost = kafkaHost;
        this.zookeeperPort = kafkaPort;
        this.kafkaPort = kafkaPort;
    }

    public KafkaTransportProtocol(String kafkaHost, int kafkaPort, String topic, String zookeeperHost, int zookeeperPort) {
        super(kafkaHost, new SimpleTopicDefinition(topic));
        this.zookeeperHost = zookeeperHost;
        this.zookeeperPort = zookeeperPort;
        this.kafkaPort = kafkaPort;
    }

    public KafkaTransportProtocol(KafkaTransportProtocol other) {
        super(other);
        this.kafkaPort = other.getKafkaPort();
        this.zookeeperHost = other.getZookeeperHost();
        this.zookeeperPort = other.getZookeeperPort();
    }

    public KafkaTransportProtocol(String kafkaHost, Integer kafkaPort, WildcardTopicDefinition wildcardTopicDefinition) {
        super(kafkaHost, wildcardTopicDefinition);
        this.kafkaPort = kafkaPort;
        this.zookeeperHost = kafkaHost;
        this.zookeeperPort = kafkaPort;
    }

    public KafkaTransportProtocol() {
    }

    public String getZookeeperHost() {
        return this.zookeeperHost;
    }

    public void setZookeeperHost(String zookeeperHost) {
        this.zookeeperHost = zookeeperHost;
    }

    public int getZookeeperPort() {
        return this.zookeeperPort;
    }

    public void setZookeeperPort(int zookeeperPort) {
        this.zookeeperPort = zookeeperPort;
    }

    public int getKafkaPort() {
        return this.kafkaPort;
    }

    public void setKafkaPort(int kafkaPort) {
        this.kafkaPort = kafkaPort;
    }

    public static long getSerialVersionUID() {
        return -4067982203807146257L;
    }

    public Integer getLingerMs() {
        return this.lingerMs;
    }

    public void setLingerMs(Integer lingerMs) {
        this.lingerMs = lingerMs;
    }

    public String getMessageMaxBytes() {
        return this.messageMaxBytes;
    }

    public void setMessageMaxBytes(String messageMaxBytes) {
        this.messageMaxBytes = messageMaxBytes;
    }

    public String getAcks() {
        return this.acks;
    }

    public void setAcks(String acks) {
        this.acks = acks;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }
}

