/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.streampipes.model.runtime.EventConverter;
import org.streampipes.model.runtime.EventFactory;
import org.streampipes.model.runtime.SchemaInfo;
import org.streampipes.model.runtime.SourceInfo;
import org.streampipes.model.runtime.field.AbstractField;
import org.streampipes.model.runtime.field.PrimitiveField;
import org.streampipes.model.schema.EventSchema;

public class Event {
    private SourceInfo sourceInfo;
    private SchemaInfo schemaInfo;
    private Map<String, AbstractField> fieldMap;

    public Event(Map<String, AbstractField> fieldMap, SourceInfo sourceInfo, SchemaInfo schemaInfo) {
        this.fieldMap = fieldMap;
        this.sourceInfo = sourceInfo;
        this.schemaInfo = schemaInfo;
    }

    public Event() {
        this.fieldMap = new HashMap<String, AbstractField>();
    }

    public Map<String, AbstractField> getFields() {
        return this.fieldMap;
    }

    public Map<String, Object> getRaw() {
        return new EventConverter(this).toMap(false);
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public Event merge(Event otherEvent, EventSchema outputSchema) {
        return EventFactory.fromEvents(this, otherEvent, outputSchema);
    }

    public AbstractField getFieldByRuntimeName(String runtimeName) {
        return this.fieldMap.entrySet().stream().map(Map.Entry::getValue).filter(entry -> entry.getFieldNameIn().equals(runtimeName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Field " + runtimeName + " not found"));
    }

    public void removeFieldBySelector(String fieldSelector) {
        this.fieldMap.remove(fieldSelector);
    }

    public AbstractField getFieldBySelector(String fieldSelector) {
        return this.getFieldBySelector(fieldSelector, this.fieldMap);
    }

    private AbstractField getFieldBySelector(String fieldSelector, Map<String, AbstractField> currentFieldMap) {
        if (currentFieldMap.containsKey(fieldSelector)) {
            return currentFieldMap.get(fieldSelector);
        }
        return this.getFieldBySelector(fieldSelector, this.getNestedItem(fieldSelector, currentFieldMap));
    }

    private Map<String, AbstractField> getNestedItem(String fieldSelector, Map<String, AbstractField> currentFieldMap) {
        String key = currentFieldMap.keySet().stream().filter(fieldSelector::startsWith).findFirst().orElseThrow(() -> new IllegalArgumentException("Key not found"));
        return (Map)currentFieldMap.get(key).getAsComposite().getRawValue();
    }

    public void updateFieldBySelector(String selector, AbstractField field) {
        if (this.fieldMap.containsKey(selector)) {
            this.fieldMap.put(selector, field);
        } else {
            this.updateFieldMap((Map)this.fieldMap.get(this.makeSelector(selector, 2)).getAsComposite().getRawValue(), selector, 2, field);
        }
    }

    private void updateFieldMap(Map<String, AbstractField> currentFieldMap, String selector, Integer position, AbstractField field) {
        if (currentFieldMap.containsKey(selector)) {
            currentFieldMap.put(selector, field);
        } else {
            this.updateFieldMap((Map)currentFieldMap.get(this.makeSelector(selector, position + 1)).getAsComposite().getRawValue(), selector, 2, field);
        }
    }

    private String makeSelector(String selector, int position) {
        String[] selectorParts = selector.split("::");
        StringBuilder selectorBuilder = new StringBuilder();
        for (int i = 0; i < position; ++i) {
            selectorBuilder.append(selectorParts[i]);
            if (i == position - 1) continue;
            selectorBuilder.append("::");
        }
        return selectorBuilder.toString();
    }

    private String makeSelector(String prefix, String runtimeName) {
        return prefix + "::" + runtimeName;
    }

    public void updateFieldBySelector(String selector, Integer value) {
        this.getFieldBySelector(selector).getAsPrimitive().setValue(value);
    }

    public void updateFieldBySelector(String selector, String value) {
        this.getFieldBySelector(selector).getAsPrimitive().setValue(value);
    }

    public void updateFieldBySelector(String selector, Float value) {
        this.getFieldBySelector(selector).getAsPrimitive().setValue(value);
    }

    public void updateFieldBySelector(String selector, Boolean value) {
        this.getFieldBySelector(selector).getAsPrimitive().setValue(value);
    }

    public void updateFieldBySelector(String selector, Double value) {
        this.getFieldBySelector(selector).getAsPrimitive().setValue(value);
    }

    public void addField(AbstractField field) {
        this.fieldMap.put(this.makeKey(field), field);
    }

    public void addField(String runtimeName, Integer value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, Long value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, Object value) {
        if (AbstractField.class.isInstance(value)) {
            ((AbstractField)value).rename(runtimeName);
            this.addField((AbstractField)value);
        } else {
            this.addPrimitive(runtimeName, value);
        }
    }

    public void addField(String runtimeName, Float value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, Double value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, Boolean value) {
        this.addPrimitive(runtimeName, value);
    }

    public void addField(String runtimeName, String value) {
        this.addPrimitive(runtimeName, value);
    }

    private void addPrimitive(String runtimeName, Object value) {
        this.fieldMap.put(runtimeName, new PrimitiveField(runtimeName, runtimeName, value));
    }

    public void addFieldAtPosition(String baseSelector, AbstractField field) {
        this.getFieldBySelector(baseSelector).getAsComposite().addField(this.makeSelector(baseSelector, field.getFieldNameIn()), field);
    }

    private String makeKey(AbstractField field) {
        return this.sourceInfo != null && this.sourceInfo.getSelectorPrefix() != null ? this.sourceInfo.getSelectorPrefix() + "::" + field.getFieldNameIn() : field.getFieldNameIn();
    }

    public Event getSubset(List<String> fieldSelectors) {
        return EventFactory.makeSubset(this, fieldSelectors);
    }
}

