/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.streampipes.model.runtime.Event;
import org.streampipes.model.runtime.field.AbstractField;
import org.streampipes.model.runtime.field.ListField;
import org.streampipes.model.runtime.field.PrimitiveField;

public class EventConverter {
    private Event event;

    public EventConverter(Event event) {
        this.event = event;
    }

    public Map<String, Object> toMap(Boolean renameProperties) {
        HashMap<String, Object> outMap = new HashMap<String, Object>();
        this.event.getFields().forEach((key, value) -> outMap.put(this.getValue((AbstractField)value, renameProperties), this.makeEntry((AbstractField)value, renameProperties)));
        return outMap;
    }

    public Map<String, Object> toMap() {
        return this.toMap(true);
    }

    public Map<String, Object> toInputEventMap() {
        return this.toMap(false);
    }

    private Object makeEntry(AbstractField value, Boolean renameProperties) {
        if (PrimitiveField.class.isInstance(value)) {
            return value.getRawValue();
        }
        if (ListField.class.isInstance(value)) {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (AbstractField field : (List)value.getAsList().getRawValue()) {
                objects.add(this.makeEntry(field, renameProperties));
            }
            return objects;
        }
        HashMap outMap = new HashMap();
        ((Map)value.getAsComposite().getRawValue()).entrySet().forEach(entry -> outMap.put(this.getValue((AbstractField)entry.getValue(), renameProperties), this.makeEntry((AbstractField)entry.getValue(), renameProperties)));
        return outMap;
    }

    private String getValue(AbstractField field, Boolean renameProperties) {
        return renameProperties != false ? field.getFieldNameOut() : field.getFieldNameIn();
    }
}

