/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.staticproperty;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyType;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/CollectionStaticProperty")
@Entity
public class CollectionStaticProperty
extends StaticProperty {
    private static final long serialVersionUID = 1L;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasStaticProperty")
    private StaticProperty staticPropertyTemplate;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/member")
    private List<StaticProperty> members;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/memberType")
    private String memberType;

    public CollectionStaticProperty() {
        super(StaticPropertyType.CollectionStaticProperty);
        this.members = new ArrayList<StaticProperty>();
    }

    public CollectionStaticProperty(String internalName, String label, String description, List<StaticProperty> members, String memberType) {
        super(StaticPropertyType.CollectionStaticProperty, internalName, label, description);
        this.members = members;
        this.memberType = memberType;
    }

    public CollectionStaticProperty(CollectionStaticProperty other) {
        super(other);
        this.members = new Cloner().staticProperties(other.getMembers());
        if (other.getStaticPropertyTemplate() != null) {
            this.staticPropertyTemplate = new Cloner().staticProperty(other.getStaticPropertyTemplate());
        }
        this.memberType = other.getMemberType();
    }

    public List<StaticProperty> getMembers() {
        return this.members;
    }

    public void setMembers(List<StaticProperty> members) {
        this.members = members;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public StaticProperty getStaticPropertyTemplate() {
        return this.staticPropertyTemplate;
    }

    public void setStaticPropertyTemplate(StaticProperty staticPropertyTemplate) {
        this.staticPropertyTemplate = staticPropertyTemplate;
    }
}

