/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.staticproperty;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyType;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/MappingProperty")
@MappedSuperclass
@Entity
public abstract class MappingProperty
extends StaticProperty {
    private static final long serialVersionUID = -7849999126274124847L;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/mapsFrom")
    private String requirementSelector;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasMapsFromOptions")
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<String> mapsFromOptions;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasPropertyScope")
    private String propertyScope;

    public MappingProperty() {
        this.mapsFromOptions = new ArrayList<String>();
        this.requirementSelector = "";
    }

    public MappingProperty(StaticPropertyType type) {
        super(type);
        this.mapsFromOptions = new ArrayList<String>();
        this.requirementSelector = "";
    }

    public MappingProperty(MappingProperty other) {
        super(other);
        this.requirementSelector = other.getRequirementSelector();
        this.propertyScope = other.getPropertyScope();
        this.mapsFromOptions = other.getMapsFromOptions();
    }

    protected MappingProperty(StaticPropertyType type, String requirementSelector, String internalName, String label, String description) {
        this(type, internalName, label, description);
        this.requirementSelector = requirementSelector;
    }

    protected MappingProperty(StaticPropertyType type, String internalName, String label, String description) {
        super(type, internalName, label, description);
        this.requirementSelector = "";
    }

    public String getRequirementSelector() {
        return this.requirementSelector;
    }

    public void setRequirementSelector(String requirementSelector) {
        this.requirementSelector = requirementSelector;
    }

    public List<String> getMapsFromOptions() {
        return this.mapsFromOptions;
    }

    public void setMapsFromOptions(List<String> mapsFromOptions) {
        this.mapsFromOptions = mapsFromOptions;
    }

    public String getPropertyScope() {
        return this.propertyScope;
    }

    public void setPropertyScope(String propertyScope) {
        this.propertyScope = propertyScope;
    }
}

