/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.model.staticproperty;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.streampipes.empire.annotations.RdfProperty;
import org.streampipes.empire.annotations.RdfsClass;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyType;
import org.streampipes.model.util.Cloner;

@RdfsClass(value="https://streampipes.org/vocabulary/v1/StaticPropertyGroup")
@Entity
public class StaticPropertyGroup
extends StaticProperty {
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/hasStaticProperty")
    private List<StaticProperty> staticProperties;
    @RdfProperty(value="https://streampipes.org/vocabulary/v1/showLabel")
    private Boolean showLabel;

    public StaticPropertyGroup() {
        super(StaticPropertyType.StaticPropertyGroup);
    }

    public StaticPropertyGroup(StaticPropertyGroup other) {
        super(other);
        this.staticProperties = new Cloner().staticProperties(other.getStaticProperties());
        this.showLabel = other.showLabel;
    }

    public StaticPropertyGroup(String internalName, String label, String description) {
        super(StaticPropertyType.StaticPropertyGroup, internalName, label, description);
    }

    public StaticPropertyGroup(String internalName, String label, String description, List<StaticProperty> staticProperties) {
        this(internalName, label, description);
        this.staticProperties = staticProperties;
    }

    public List<StaticProperty> getStaticProperties() {
        return this.staticProperties;
    }

    public void setStaticProperties(List<StaticProperty> staticProperties) {
        this.staticProperties = staticProperties;
    }
}

