/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.assets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.streampipes.commons.zip.ZipFileExtractor;
import org.streampipes.manager.assets.AssetConstants;
import org.streampipes.manager.assets.DocumentationParser;

public class AssetExtractor {
    private InputStream zipInputStream;
    private String appId;

    public AssetExtractor(InputStream zipInputStream, String appId) {
        this.zipInputStream = zipInputStream;
        this.appId = appId;
    }

    public void extractAssetContents() throws IOException {
        new ZipFileExtractor(this.zipInputStream).extractZipToFile(this.makeAssetLocation(this.appId));
        this.replaceImagePaths();
    }

    private void replaceImagePaths() {
        new DocumentationParser(new File(this.makeDocumentationAssetPath(this.appId)), this.appId).replaceImageUrls();
    }

    private String makeAssetLocation(String appId) {
        return AssetConstants.ASSET_BASE_DIR + File.separator + appId;
    }

    private String makeDocumentationAssetPath(String appId) {
        return this.makeAssetLocation(appId) + File.separator + "documentation.md";
    }
}

