/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.assets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.streampipes.manager.assets.AssetConstants;
import org.streampipes.manager.assets.AssetExtractor;
import org.streampipes.manager.assets.AssetFetcher;

public class AssetManager {
    public static byte[] getAssetIcon(String appId) throws IOException {
        return Files.readAllBytes(Paths.get(AssetManager.getAssetIconPath(appId), new String[0]));
    }

    public static String getAssetDocumentation(String appId) throws IOException {
        return new String(Files.readAllBytes(Paths.get(AssetManager.getAssetDocumentationPath(appId), new String[0])));
    }

    public static byte[] getAsset(String appId, String assetName) throws IOException {
        return Files.readAllBytes(Paths.get(AssetManager.getAssetPath(appId, assetName), new String[0]));
    }

    public static void storeAsset(String pipelineElementUri, String appId) throws IOException {
        InputStream assetStream = new AssetFetcher(pipelineElementUri, appId).fetchPipelineElementAssets();
        new AssetExtractor(assetStream, appId).extractAssetContents();
    }

    public static void deleteAsset(String appId) throws IOException {
        Path path = Paths.get(AssetManager.getAssetDir(appId), new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)path.toFile());
        }
    }

    private static String getAssetPath(String appId, String assetName) {
        return AssetManager.getAssetDir(appId) + File.separator + assetName;
    }

    private static String getAssetIconPath(String appId) {
        return AssetManager.getAssetDir(appId) + File.separator + "icon.png";
    }

    private static String getAssetDocumentationPath(String appId) {
        return AssetManager.getAssetDir(appId) + File.separator + "documentation.md";
    }

    private static String getAssetDir(String appId) {
        return AssetConstants.ASSET_BASE_DIR + File.separator + appId;
    }
}

