/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.data;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.streampipes.manager.data.PipelineGraph;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.client.pipeline.Pipeline;

public class PipelineGraphBuilder {
    private Pipeline pipeline;
    private List<NamedStreamPipesEntity> allPipelineElements;
    private List<InvocableStreamPipesEntity> invocableElements;

    public PipelineGraphBuilder(Pipeline pipeline) {
        this.pipeline = pipeline;
        this.allPipelineElements = this.addAll();
        this.invocableElements = this.addInvocable();
    }

    private List<NamedStreamPipesEntity> addAll() {
        ArrayList<NamedStreamPipesEntity> allElements = new ArrayList<NamedStreamPipesEntity>();
        allElements.addAll(this.pipeline.getStreams());
        allElements.addAll(this.addInvocable());
        return allElements;
    }

    private List<InvocableStreamPipesEntity> addInvocable() {
        ArrayList<InvocableStreamPipesEntity> allElements = new ArrayList<InvocableStreamPipesEntity>();
        allElements.addAll(this.pipeline.getSepas());
        allElements.addAll(this.pipeline.getActions());
        return allElements;
    }

    public PipelineGraph buildGraph() {
        PipelineGraph pipelineGraph = new PipelineGraph();
        this.allPipelineElements.forEach(arg_0 -> ((PipelineGraph)pipelineGraph).addVertex(arg_0));
        for (NamedStreamPipesEntity source : this.allPipelineElements) {
            List<InvocableStreamPipesEntity> targets = this.findTargets(source.getDOM());
            targets.forEach(t -> pipelineGraph.addEdge(source, t, this.createEdge(source, (NamedStreamPipesEntity)t)));
        }
        return pipelineGraph;
    }

    private List<InvocableStreamPipesEntity> findTargets(String domId) {
        return this.invocableElements.stream().filter(i -> i.getConnectedTo().contains(domId)).collect(Collectors.toList());
    }

    private String createEdge(NamedStreamPipesEntity sourceVertex, NamedStreamPipesEntity targetVertex) {
        return sourceVertex.getDOM() + "-" + targetVertex.getDOM();
    }
}

