/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.endpoint;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.fluent.Request;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.model.client.endpoint.RdfEndpoint;
import org.streampipes.model.client.endpoint.RdfEndpointItem;

public class EndpointItemFetcher {
    Logger logger = LoggerFactory.getLogger(EndpointItemFetcher.class);
    private List<RdfEndpoint> rdfEndpoints;

    public EndpointItemFetcher(List<RdfEndpoint> rdfEndpoints) {
        this.rdfEndpoints = rdfEndpoints;
    }

    public List<RdfEndpointItem> getItems() {
        ArrayList<RdfEndpointItem> endpointItems = new ArrayList<RdfEndpointItem>();
        this.rdfEndpoints.forEach(e -> endpointItems.addAll(this.getEndpointItems((RdfEndpoint)e)));
        return endpointItems;
    }

    private List<RdfEndpointItem> getEndpointItems(RdfEndpoint e) {
        try {
            String result = Request.Get((String)e.getEndpointUrl()).addHeader((Header)new BasicHeader("Accept", "application/json")).execute().returnContent().asString();
            return (List)new Gson().fromJson(result, new TypeToken<List<RdfEndpointItem>>(){}.getType());
        }
        catch (IOException e1) {
            this.logger.warn("Processing Element Descriptions could not be fetched from RDF endpoint: " + e.getEndpointUrl());
            return new ArrayList<RdfEndpointItem>();
        }
    }
}

