/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.endpoint;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.streampipes.manager.endpoint.HttpJsonParser;
import org.streampipes.manager.operations.Operations;
import org.streampipes.model.client.messages.Message;
import org.streampipes.model.client.messages.NotificationType;
import org.streampipes.model.client.messages.Notifications;

public class EndpointItemParser {
    public Message parseAndAddEndpointItem(String uri, String username, boolean publicElement) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
            String payload = this.parseURIContent(uri, null);
            return Operations.verifyAndAddElement(payload, username, publicElement);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Notifications.error((NotificationType)NotificationType.PARSE_ERROR, (String)e.getMessage());
        }
    }

    private String parseURIContent(String payload, String mediaType) throws URISyntaxException, IOException {
        URI uri = new URI(payload);
        return HttpJsonParser.getContentFromUrl(uri, mediaType);
    }
}

