/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.execution.http;

import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.manager.execution.http.HttpRequestBuilder;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.client.pipeline.PipelineElementStatus;
import org.streampipes.model.client.pipeline.PipelineOperationStatus;

public class GraphSubmitter {
    private List<InvocableStreamPipesEntity> graphs;
    private List<SpDataSet> dataSets;
    private String pipelineId;
    private String pipelineName;
    private static final Logger LOG = LoggerFactory.getLogger(GraphSubmitter.class);

    public GraphSubmitter(String pipelineId, String pipelineName, List<InvocableStreamPipesEntity> graphs, List<SpDataSet> dataSets) {
        this.graphs = graphs;
        this.pipelineId = pipelineId;
        this.pipelineName = pipelineName;
        this.dataSets = dataSets;
    }

    public PipelineOperationStatus invokeGraphs() {
        PipelineOperationStatus status = new PipelineOperationStatus();
        status.setPipelineId(this.pipelineId);
        status.setPipelineName(this.pipelineName);
        this.graphs.forEach(g -> status.addPipelineElementStatus(new HttpRequestBuilder((NamedStreamPipesEntity)g, g.getBelongsTo()).invoke()));
        if (status.getElementStatus().stream().allMatch(PipelineElementStatus::isSuccess)) {
            this.dataSets.forEach(dataSet -> status.addPipelineElementStatus(new HttpRequestBuilder((NamedStreamPipesEntity)dataSet, dataSet.getUri()).invoke()));
        }
        status.setSuccess(status.getElementStatus().stream().allMatch(PipelineElementStatus::isSuccess));
        if (status.isSuccess()) {
            status.setTitle("Pipeline " + this.pipelineName + " successfully started");
        } else {
            LOG.info("Could not start pipeline, initializing rollback...");
            this.rollbackInvokedPipelineElements(status);
            status.setTitle("Could not start pipeline" + this.pipelineName + ".");
        }
        return status;
    }

    private void rollbackInvokedPipelineElements(PipelineOperationStatus status) {
        for (PipelineElementStatus s : status.getElementStatus()) {
            if (!s.isSuccess()) continue;
            Optional<InvocableStreamPipesEntity> graph = this.findGraph(s.getElementId());
            graph.ifPresent(g -> {
                LOG.info("Rolling back element " + g.getElementId());
                new HttpRequestBuilder((NamedStreamPipesEntity)g, g.getBelongsTo()).detach();
            });
        }
    }

    private Optional<InvocableStreamPipesEntity> findGraph(String elementId) {
        return this.graphs.stream().filter(g -> g.getBelongsTo().equals(elementId)).findFirst();
    }

    public PipelineOperationStatus detachGraphs() {
        PipelineOperationStatus status = new PipelineOperationStatus();
        status.setPipelineId(this.pipelineId);
        status.setPipelineName(this.pipelineName);
        this.graphs.forEach(g -> status.addPipelineElementStatus(new HttpRequestBuilder((NamedStreamPipesEntity)g, g.getUri()).detach()));
        this.dataSets.forEach(dataSet -> status.addPipelineElementStatus(new HttpRequestBuilder((NamedStreamPipesEntity)dataSet, dataSet.getUri() + "/" + dataSet.getDatasetInvocationId()).detach()));
        status.setSuccess(status.getElementStatus().stream().allMatch(PipelineElementStatus::isSuccess));
        if (status.isSuccess()) {
            status.setTitle("Pipeline " + this.pipelineName + " successfully stopped");
        } else {
            status.setTitle("Could not stop all pipeline elements of pipeline " + this.pipelineName + ".");
        }
        return status;
    }
}

