/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.execution.http;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.eclipse.rdf4j.model.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.commons.Utils;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.client.pipeline.PipelineElementStatus;
import org.streampipes.serializers.jsonld.JsonLdTransformer;

public class HttpRequestBuilder {
    private NamedStreamPipesEntity payload;
    private String belongsTo;
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestBuilder.class);

    public HttpRequestBuilder(NamedStreamPipesEntity payload, String belongsTo) {
        this.payload = payload;
        this.belongsTo = belongsTo;
    }

    public PipelineElementStatus invoke() {
        LOG.info("Invoking element: " + this.belongsTo);
        try {
            Response httpResp = Request.Post((String)this.belongsTo).bodyString(this.jsonLd(), ContentType.APPLICATION_JSON).connectTimeout(10000).execute();
            return this.handleResponse(httpResp);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return new PipelineElementStatus(this.belongsTo, this.payload.getName(), false, e.getMessage());
        }
    }

    public PipelineElementStatus detach() {
        try {
            Response httpResp = Request.Delete((String)this.belongsTo).connectTimeout(10000).execute();
            return this.handleResponse(httpResp);
        }
        catch (Exception e) {
            LOG.error("Could not stop pipeline " + this.belongsTo, (Object)e.getMessage());
            return new PipelineElementStatus(this.belongsTo, this.payload.getName(), false, e.getMessage());
        }
    }

    private PipelineElementStatus handleResponse(Response httpResp) throws JsonSyntaxException, ClientProtocolException, IOException {
        String resp = httpResp.returnContent().asString();
        org.streampipes.model.Response streamPipesResp = (org.streampipes.model.Response)new Gson().fromJson(resp, org.streampipes.model.Response.class);
        return this.convert(streamPipesResp);
    }

    private String jsonLd() throws Exception {
        return Utils.asString((Graph)new JsonLdTransformer().toJsonLd((Object)this.payload));
    }

    private PipelineElementStatus convert(org.streampipes.model.Response response) {
        return new PipelineElementStatus(this.belongsTo, this.payload.getName(), response.isSuccess().booleanValue(), response.getOptionalMessage());
    }
}

