/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.execution.http;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.lightcouch.DocumentConflictException;
import org.streampipes.manager.execution.http.GraphSubmitter;
import org.streampipes.manager.execution.status.PipelineStatusManager;
import org.streampipes.manager.execution.status.SepMonitoringManager;
import org.streampipes.manager.util.TemporaryGraphStorage;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.client.pipeline.PipelineOperationStatus;
import org.streampipes.model.client.pipeline.PipelineStatusMessage;
import org.streampipes.model.client.pipeline.PipelineStatusMessageType;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.graph.DataSinkInvocation;
import org.streampipes.model.staticproperty.SecretStaticProperty;
import org.streampipes.storage.api.IPipelineStorage;
import org.streampipes.storage.management.StorageDispatcher;
import org.streampipes.user.management.encryption.CredentialsManager;

public class PipelineExecutor {
    private Pipeline pipeline;
    private boolean visualize;
    private boolean storeStatus;
    private boolean monitor;

    public PipelineExecutor(Pipeline pipeline, boolean visualize, boolean storeStatus, boolean monitor) {
        this.pipeline = pipeline;
        this.visualize = visualize;
        this.storeStatus = storeStatus;
        this.monitor = monitor;
    }

    public PipelineOperationStatus startPipeline() {
        List sepas = this.pipeline.getSepas();
        List secs = this.pipeline.getActions();
        List<SpDataSet> dataSets = this.pipeline.getStreams().stream().filter(s -> s instanceof SpDataSet).map(s -> new SpDataSet((SpDataSet)s)).collect(Collectors.toList());
        for (SpDataSet ds : dataSets) {
            ds.setCorrespondingPipeline(this.pipeline.getPipelineId());
        }
        ArrayList<InvocableStreamPipesEntity> graphs = new ArrayList<InvocableStreamPipesEntity>();
        graphs.addAll(sepas);
        graphs.addAll(secs);
        List<InvocableStreamPipesEntity> decryptedGraphs = this.decryptSecrets(graphs);
        graphs.forEach(g -> g.setStreamRequirements(Arrays.asList(new SpDataStream[0])));
        PipelineOperationStatus status = new GraphSubmitter(this.pipeline.getPipelineId(), this.pipeline.getName(), decryptedGraphs, dataSets).invokeGraphs();
        if (status.isSuccess()) {
            this.storeInvocationGraphs(this.pipeline.getPipelineId(), graphs, dataSets);
            PipelineStatusManager.addPipelineStatus(this.pipeline.getPipelineId(), new PipelineStatusMessage(this.pipeline.getPipelineId(), System.currentTimeMillis(), PipelineStatusMessageType.PIPELINE_STARTED.title(), PipelineStatusMessageType.PIPELINE_STARTED.description()));
            if (this.monitor) {
                SepMonitoringManager.addObserver(this.pipeline.getPipelineId());
            }
            if (this.storeStatus) {
                this.setPipelineStarted(this.pipeline);
            }
        }
        return status;
    }

    private List<InvocableStreamPipesEntity> decryptSecrets(List<InvocableStreamPipesEntity> graphs) {
        ArrayList<InvocableStreamPipesEntity> decryptedGraphs = new ArrayList<InvocableStreamPipesEntity>();
        graphs.stream().map(g -> {
            if (g instanceof DataProcessorInvocation) {
                return new DataProcessorInvocation((DataProcessorInvocation)g);
            }
            return new DataSinkInvocation((DataSinkInvocation)g);
        }).forEach(g -> {
            g.getStaticProperties().stream().filter(SecretStaticProperty.class::isInstance).forEach(sp -> {
                try {
                    String decrypted = CredentialsManager.decrypt((String)this.pipeline.getCreatedByUser(), (String)((SecretStaticProperty)sp).getValue());
                    ((SecretStaticProperty)sp).setValue(decrypted);
                    ((SecretStaticProperty)sp).setEncrypted(Boolean.valueOf(false));
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            });
            decryptedGraphs.add((InvocableStreamPipesEntity)g);
        });
        return decryptedGraphs;
    }

    public PipelineOperationStatus stopPipeline() {
        List<InvocableStreamPipesEntity> graphs = TemporaryGraphStorage.graphStorage.get(this.pipeline.getPipelineId());
        List<SpDataSet> dataSets = TemporaryGraphStorage.datasetStorage.get(this.pipeline.getPipelineId());
        PipelineOperationStatus status = new GraphSubmitter(this.pipeline.getPipelineId(), this.pipeline.getName(), graphs, dataSets).detachGraphs();
        if (status.isSuccess()) {
            if (this.visualize) {
                StorageDispatcher.INSTANCE.getNoSqlStore().getVisualizationStorageApi().deleteVisualization(this.pipeline.getPipelineId());
            }
            if (this.storeStatus) {
                this.setPipelineStopped(this.pipeline);
            }
            PipelineStatusManager.addPipelineStatus(this.pipeline.getPipelineId(), new PipelineStatusMessage(this.pipeline.getPipelineId(), System.currentTimeMillis(), PipelineStatusMessageType.PIPELINE_STOPPED.title(), PipelineStatusMessageType.PIPELINE_STOPPED.description()));
            if (this.monitor) {
                SepMonitoringManager.removeObserver(this.pipeline.getPipelineId());
            }
        }
        return status;
    }

    private void setPipelineStarted(Pipeline pipeline) {
        pipeline.setRunning(true);
        pipeline.setStartedAt(new Date().getTime());
        try {
            this.getPipelineStorageApi().updatePipeline(pipeline);
        }
        catch (DocumentConflictException documentConflictException) {
            // empty catch block
        }
    }

    private void setPipelineStopped(Pipeline pipeline) {
        pipeline.setRunning(false);
        this.getPipelineStorageApi().updatePipeline(pipeline);
    }

    private void storeInvocationGraphs(String pipelineId, List<InvocableStreamPipesEntity> graphs, List<SpDataSet> dataSets) {
        TemporaryGraphStorage.graphStorage.put(pipelineId, graphs);
        TemporaryGraphStorage.datasetStorage.put(pipelineId, dataSets);
    }

    private IPipelineStorage getPipelineStorageApi() {
        return StorageDispatcher.INSTANCE.getNoSqlStore().getPipelineStorageAPI();
    }
}

