/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.execution.http;

import java.security.GeneralSecurityException;
import java.util.List;
import java.util.stream.Collectors;
import org.streampipes.manager.data.PipelineGraph;
import org.streampipes.manager.data.PipelineGraphBuilder;
import org.streampipes.manager.matching.InvocationGraphBuilder;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.graph.DataSinkInvocation;
import org.streampipes.model.staticproperty.SecretStaticProperty;
import org.streampipes.storage.management.StorageDispatcher;
import org.streampipes.user.management.encryption.CredentialsManager;

public class PipelineStorageService {
    private Pipeline pipeline;

    public PipelineStorageService(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void addPipeline() {
        PipelineGraph pipelineGraph = new PipelineGraphBuilder(this.pipeline).buildGraph();
        InvocationGraphBuilder builder = new InvocationGraphBuilder(pipelineGraph, this.pipeline.getPipelineId());
        List<InvocableStreamPipesEntity> graphs = this.encryptSecrets(builder.buildGraphs());
        List<DataSinkInvocation> secs = this.filter(graphs, DataSinkInvocation.class);
        List<DataProcessorInvocation> sepas = this.filter(graphs, DataProcessorInvocation.class);
        this.pipeline.setSepas(sepas);
        this.pipeline.setActions(secs);
        StorageDispatcher.INSTANCE.getNoSqlStore().getPipelineStorageAPI().store(this.pipeline);
    }

    private List<InvocableStreamPipesEntity> encryptSecrets(List<InvocableStreamPipesEntity> graphs) {
        graphs.forEach(g -> g.getStaticProperties().stream().filter(SecretStaticProperty.class::isInstance).forEach(secret -> {
            if (!((SecretStaticProperty)secret).getEncrypted().booleanValue()) {
                try {
                    String encrypted = CredentialsManager.encrypt((String)this.pipeline.getCreatedByUser(), (String)((SecretStaticProperty)secret).getValue());
                    ((SecretStaticProperty)secret).setValue(encrypted);
                    ((SecretStaticProperty)secret).setEncrypted(Boolean.valueOf(true));
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            }
        }));
        return graphs;
    }

    private <T> List<T> filter(List<InvocableStreamPipesEntity> graphs, Class<T> clazz) {
        return graphs.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }
}

