/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.execution.status;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.streampipes.model.client.pipeline.PipelineStatusMessage;

public class PipelineStatusManager {
    private static Map<String, List<PipelineStatusMessage>> pipelineStatusMessages = new HashMap<String, List<PipelineStatusMessage>>();

    public static void addPipelineStatus(String pipelineId, PipelineStatusMessage message) {
        if (PipelineStatusManager.isInitialized(pipelineId)) {
            pipelineStatusMessages.get(pipelineId).add(message);
        } else {
            ArrayList<PipelineStatusMessage> statusMessageList = new ArrayList<PipelineStatusMessage>();
            statusMessageList.add(message);
            pipelineStatusMessages.put(pipelineId, statusMessageList);
        }
    }

    private static boolean isInitialized(String pipelineId) {
        return pipelineStatusMessages.containsKey(pipelineId);
    }

    public static List<PipelineStatusMessage> getPipelineStatus(String pipelineId) {
        if (!PipelineStatusManager.isInitialized(pipelineId)) {
            return new ArrayList<PipelineStatusMessage>();
        }
        return pipelineStatusMessages.get(pipelineId);
    }

    public static List<PipelineStatusMessage> getPipelineStatus(String pipelineId, int numberOfLatestEntries) {
        List<PipelineStatusMessage> messages = PipelineStatusManager.getPipelineStatus(pipelineId);
        int statusMessageCount = messages.size();
        if (statusMessageCount <= numberOfLatestEntries) {
            return messages;
        }
        return messages.subList(messages.size() - numberOfLatestEntries, messages.size());
    }
}

