/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.info;

import org.streampipes.model.client.version.SystemInfo;

public class SystemInfoProvider {
    public SystemInfo getSystemInfo() {
        SystemInfo systemInfo = new SystemInfo();
        systemInfo.setJavaVmName(this.getProperty("java.vm.name"));
        systemInfo.setJavaVmVendor(this.getProperty("java.vm.vendor"));
        systemInfo.setJavaVmVersion(this.getProperty("java.vm.version"));
        systemInfo.setJavaRuntimeName(this.getProperty("java.runtime.name"));
        systemInfo.setJavaRuntimeVersion(this.getProperty("java.runtime.version"));
        systemInfo.setOsName(this.getProperty("os.name"));
        systemInfo.setOsVersion(this.getProperty("os.version"));
        systemInfo.setCpu(this.getProperty("sun.cpu.isalist"));
        Runtime runtime = Runtime.getRuntime();
        systemInfo.setTotalMemory(runtime.totalMemory());
        systemInfo.setFreeMemory(runtime.freeMemory());
        systemInfo.setTotalMemoryKB(runtime.totalMemory() / 1024L);
        systemInfo.setFreeMemoryKB(runtime.freeMemory() / 1024L);
        return systemInfo;
    }

    private String getProperty(String key) {
        String propValue = null;
        try {
            propValue = System.getProperty(key, "");
        }
        catch (Exception ex) {
            propValue = "unknown";
        }
        return propValue;
    }
}

