/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching;

import java.util.Arrays;
import org.apache.commons.lang.RandomStringUtils;
import org.streampipes.config.backend.BackendConfig;
import org.streampipes.manager.util.TopicGenerator;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.client.pipeline.DataSetModificationMessage;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.grounding.KafkaTransportProtocol;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.model.grounding.TransportProtocol;

public class DataSetGroundingSelector {
    private SpDataSet spDataSet;

    public DataSetGroundingSelector(SpDataSet spDataSet) {
        this.spDataSet = spDataSet;
    }

    public DataSetModificationMessage selectGrounding() {
        KafkaTransportProtocol protocol = new KafkaTransportProtocol(BackendConfig.INSTANCE.getKafkaHost(), BackendConfig.INSTANCE.getKafkaPort(), TopicGenerator.generateRandomTopic(), BackendConfig.INSTANCE.getZookeeperHost(), BackendConfig.INSTANCE.getZookeeperPort());
        TransportFormat format = (TransportFormat)this.spDataSet.getSupportedGrounding().getTransportFormats().get(0);
        EventGrounding outputGrounding = new EventGrounding();
        outputGrounding.setTransportProtocol((TransportProtocol)protocol);
        outputGrounding.setTransportFormats(Arrays.asList(format));
        return new DataSetModificationMessage(outputGrounding, RandomStringUtils.randomAlphanumeric((int)10));
    }
}

