/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching;

import java.util.List;
import java.util.Set;
import org.streampipes.config.backend.BackendConfig;
import org.streampipes.manager.matching.GroundingSelector;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.grounding.TransportFormat;

public class FormatSelector
extends GroundingSelector {
    public FormatSelector(NamedStreamPipesEntity source, Set<InvocableStreamPipesEntity> targets) {
        super(source, targets);
    }

    public TransportFormat getTransportFormat() {
        if (this.source instanceof SpDataStream) {
            return (TransportFormat)((SpDataStream)this.source).getEventGrounding().getTransportFormats().get(0);
        }
        List prioritizedFormats = BackendConfig.INSTANCE.getMessagingSettings().getPrioritizedFormats();
        return prioritizedFormats.stream().filter(pf -> this.supportsFormat(pf.getMessageFormat())).findFirst().map(pf -> new TransportFormat(pf.getMessageFormat())).orElse(new TransportFormat("http://sepa.event-processing.org/sepa#json"));
    }

    public <T extends TransportFormat> boolean supportsFormat(String format) {
        List<InvocableStreamPipesEntity> elements = this.buildInvocables();
        return elements.stream().allMatch(e -> e.getSupportedGrounding().getTransportFormats().stream().anyMatch(s -> s.getRdfType().contains(format)));
    }
}

